/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

final class FinishableStreamSinkChannel
implements StreamSinkChannel {
    private final StreamSinkChannel delegate;
    private volatile ChannelListener<? super FinishableStreamSinkChannel> writeListener;
    private volatile ChannelListener<? super FinishableStreamSinkChannel> closeListener;
    private final ChannelListener<? super FinishableStreamSinkChannel> finishListener;
    private volatile int shutdownState = 0;
    private static final AtomicIntegerFieldUpdater<FinishableStreamSinkChannel> shutdownStateUpdater = AtomicIntegerFieldUpdater.newUpdater(FinishableStreamSinkChannel.class, "shutdownState");

    FinishableStreamSinkChannel(StreamSinkChannel delegate, final ChannelListener<? super FinishableStreamSinkChannel> finishListener) {
        this.delegate = delegate;
        this.finishListener = finishListener;
        delegate.getWriteSetter().set((ChannelListener)new ChannelListener<StreamSinkChannel>(){

            public void handleEvent(StreamSinkChannel channel) {
                ChannelListeners.invokeChannelListener((Channel)((Object)FinishableStreamSinkChannel.this), (ChannelListener)FinishableStreamSinkChannel.this.writeListener);
            }
        });
        delegate.getCloseSetter().set((ChannelListener)new ChannelListener<StreamSinkChannel>(){

            public void handleEvent(StreamSinkChannel channel) {
                ChannelListeners.invokeChannelListener((Channel)((Object)FinishableStreamSinkChannel.this), (ChannelListener)FinishableStreamSinkChannel.this.closeListener);
                int state = shutdownStateUpdater.get(FinishableStreamSinkChannel.this);
                if (state != 2 && shutdownStateUpdater.compareAndSet(FinishableStreamSinkChannel.this, state, 2)) {
                    ChannelListeners.invokeChannelListener((Channel)((Object)FinishableStreamSinkChannel.this), (ChannelListener)finishListener);
                }
            }
        });
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return new ChannelListener.Setter<StreamSinkChannel>(){

            public void set(ChannelListener<? super StreamSinkChannel> listener) {
                FinishableStreamSinkChannel.this.writeListener = listener;
            }
        };
    }

    public void setWriteListener(ChannelListener<? super FinishableStreamSinkChannel> writeListener) {
        this.writeListener = writeListener;
    }

    public void setCloseListener(ChannelListener<? super FinishableStreamSinkChannel> closeListener) {
        this.closeListener = closeListener;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return new ChannelListener.Setter<StreamSinkChannel>(){

            public void set(ChannelListener<? super StreamSinkChannel> listener) {
                FinishableStreamSinkChannel.this.closeListener = listener;
            }
        };
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this.delegate.transferFrom(src, position, count);
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return this.delegate.transferFrom(source, count, throughBuffer);
    }

    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.delegate.write(srcs);
    }

    public void suspendWrites() {
        this.delegate.suspendWrites();
    }

    public void resumeWrites() {
        this.delegate.resumeWrites();
    }

    public boolean isWriteResumed() {
        return this.delegate.isWriteResumed();
    }

    public void wakeupWrites() {
        this.delegate.wakeupWrites();
    }

    public void shutdownWrites() throws IOException {
        this.delegate.shutdownWrites();
        shutdownStateUpdater.compareAndSet(this, 0, 1);
    }

    public void awaitWritable() throws IOException {
        this.delegate.awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitWritable(time, timeUnit);
    }

    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    public boolean flush() throws IOException {
        boolean val = this.delegate.flush();
        if (val && shutdownStateUpdater.compareAndSet(this, 1, 2)) {
            ChannelListeners.invokeChannelListener((Channel)((Object)this), this.finishListener);
        }
        return val;
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.delegate.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.delegate.setOption(option, value);
    }
}

