/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.httpparser.HttpExchangeBuilder;
import io.undertow.server.httpparser.HttpParser;
import io.undertow.server.httpparser.ParseState;
import io.undertow.util.GatedStreamSinkChannel;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

final class HttpReadListener
implements ChannelListener<PushBackStreamChannel> {
    private final StreamSinkChannel responseChannel;
    private volatile ParseState state;
    private volatile HttpExchangeBuilder builder;
    private final HttpServerConnection connection;

    HttpReadListener(StreamSinkChannel responseChannel, HttpServerConnection connection) {
        this.responseChannel = responseChannel;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(PushBackStreamChannel channel) {
        Pooled pooled = this.connection.getBufferPool().allocate();
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        buffer.clear();
        boolean free = true;
        try {
            int remaining;
            int res;
            try {
                res = channel.read(buffer);
            }
            catch (IOException e) {
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debugf(e, "Connection closed with IOException", new Object[0]);
                }
                IoUtils.safeClose((Closeable)channel);
                if (free) {
                    pooled.free();
                }
                return;
            }
            if (res == 0) {
                channel.resumeReads();
                return;
            }
            if (res == -1) {
                try {
                    channel.shutdownReads();
                    StreamSinkChannel responseChannel = this.responseChannel;
                    responseChannel.shutdownWrites();
                    if (!responseChannel.flush()) {
                        responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                        responseChannel.resumeWrites();
                    }
                }
                catch (IOException e) {
                    if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                        UndertowLogger.REQUEST_LOGGER.debugf(e, "Connection closed with IOException when attempting to shut down reads", new Object[0]);
                    }
                    IoUtils.safeClose((Closeable)channel);
                    if (free) {
                        pooled.free();
                    }
                    return;
                }
                return;
            }
            buffer.flip();
            if (this.state == null) {
                this.state = new ParseState();
                this.builder = new HttpExchangeBuilder();
            }
            if ((remaining = HttpParser.INSTANCE.handle(buffer, res, this.state, this.builder)) > 0) {
                free = false;
                channel.unget(pooled);
            }
            if (this.state.isComplete()) {
                channel.getReadSetter().set(null);
                channel.suspendReads();
                StreamSinkChannel ourResponseChannel = this.responseChannel;
                Object permit = new Object();
                GatedStreamSinkChannel nextRequestResponseChannel = new GatedStreamSinkChannel((StreamSinkChannel)this.connection.getChannel(), permit, false, true);
                HeaderMap requestHeaders = this.builder.getHeaders();
                HeaderMap responseHeaders = new HeaderMap();
                Map<String, Deque<String>> parameters = this.builder.getQueryParameters();
                String method = this.builder.getMethod();
                String protocol = this.builder.getProtocol();
                final StartNextRequestAction startNextRequestAction = new StartNextRequestAction(channel, nextRequestResponseChannel, this.connection);
                ResponseTerminateAction responseTerminateAction = new ResponseTerminateAction(nextRequestResponseChannel, permit);
                final HttpServerExchange httpServerExchange = new HttpServerExchange(this.connection, requestHeaders, responseHeaders, parameters, method, protocol, (StreamSourceChannel)channel, ourResponseChannel, startNextRequestAction, responseTerminateAction);
                try {
                    httpServerExchange.setRequestURI(this.builder.getFullPath());
                    httpServerExchange.setRelativePath(this.builder.getRelativePath());
                    httpServerExchange.setRequestPath(this.builder.getRelativePath());
                    this.state = null;
                    this.builder = null;
                    this.connection.getRootHandler().handleRequest(httpServerExchange, new HttpCompletionHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleComplete() {
                            try {
                                httpServerExchange.cleanup();
                            }
                            finally {
                                startNextRequestAction.completionHandler();
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(t);
                    IoUtils.safeClose((Closeable)((Object)nextRequestResponseChannel));
                    IoUtils.safeClose((Closeable)channel);
                }
            }
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    private static class ResponseTerminateAction
    implements Runnable {
        private volatile GatedStreamSinkChannel nextRequestResponseChannel;
        private volatile Object permit;

        public ResponseTerminateAction(GatedStreamSinkChannel nextRequestResponseChannel, Object permit) {
            this.nextRequestResponseChannel = nextRequestResponseChannel;
            this.permit = permit;
        }

        @Override
        public void run() {
            this.nextRequestResponseChannel.openGate(this.permit);
            this.nextRequestResponseChannel = null;
            this.permit = null;
        }
    }

    private static class StartNextRequestAction
    implements Runnable {
        private volatile PushBackStreamChannel channel;
        private volatile GatedStreamSinkChannel nextRequestResponseChannel;
        private volatile HttpServerConnection connection;
        private volatile int state = 0;
        private static final AtomicIntegerFieldUpdater<StartNextRequestAction> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(StartNextRequestAction.class, "state");

        public StartNextRequestAction(PushBackStreamChannel channel, GatedStreamSinkChannel nextRequestResponseChannel, HttpServerConnection connection) {
            this.channel = channel;
            this.nextRequestResponseChannel = nextRequestResponseChannel;
            this.connection = connection;
        }

        @Override
        public void run() {
            int state;
            do {
                if ((state = stateUpdater.get(this)) == 3) {
                    stateUpdater.set(this, 1);
                    this.channel.getReadSetter().set((ChannelListener)new HttpReadListener(this.nextRequestResponseChannel, this.connection));
                    this.channel.resumeReads();
                    this.nextRequestResponseChannel = null;
                    this.connection = null;
                    this.channel = null;
                    return;
                }
                if (state != 0 || !this.connection.startRequest()) continue;
                stateUpdater.set(this, 1);
                this.channel.getReadSetter().set((ChannelListener)new HttpReadListener(this.nextRequestResponseChannel, this.connection));
                this.channel.resumeReads();
                this.nextRequestResponseChannel = null;
                this.connection = null;
                this.channel = null;
                return;
            } while (!stateUpdater.compareAndSet(this, state, 2));
        }

        public void completionHandler() {
            int state;
            do {
                if ((state = stateUpdater.get(this)) == 1) {
                    return;
                }
                if (state != 2) continue;
                stateUpdater.set(this, 1);
                this.channel.getReadSetter().set((ChannelListener)new HttpReadListener(this.nextRequestResponseChannel, this.connection));
                this.channel.resumeReads();
                this.nextRequestResponseChannel = null;
                this.connection = null;
                this.channel = null;
                return;
            } while (!stateUpdater.compareAndSet(this, state, 3));
        }
    }
}

