/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.TruncatedResponseException;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

final class HttpResponseChannel
implements StreamSinkChannel {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.channel.response");
    private final StreamSinkChannel delegate;
    private final Pool<ByteBuffer> pool;
    private volatile int state = 1;
    private Iterator<String> nameIterator;
    private String string;
    private String headerName;
    private Iterator<String> valueIterator;
    private int charIndex;
    private Pooled<ByteBuffer> pooledBuffer;
    private final HttpServerExchange exchange;
    private final ChannelListener.SimpleSetter<HttpResponseChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<HttpResponseChannel> closeSetter = new ChannelListener.SimpleSetter();
    private static final AtomicIntegerFieldUpdater<HttpResponseChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpResponseChannel.class, "state");
    private static final int STATE_BODY = 0;
    private static final int STATE_START = 1;
    private static final int STATE_HDR_NAME = 2;
    private static final int STATE_HDR_D = 3;
    private static final int STATE_HDR_DS = 4;
    private static final int STATE_HDR_VAL = 5;
    private static final int STATE_HDR_EOL_CR = 6;
    private static final int STATE_HDR_EOL_LF = 7;
    private static final int STATE_HDR_FINAL_CR = 8;
    private static final int STATE_HDR_FINAL_LF = 9;
    private static final int STATE_BUF_FLUSH = 10;
    private static final int MASK_STATE = 15;
    private static final int FLAG_ENTERED = 16;
    private static final int FLAG_SHUTDOWN = 32;

    HttpResponseChannel(StreamSinkChannel delegate, Pool<ByteBuffer> pool, HttpServerExchange exchange) {
        this.delegate = delegate;
        this.pool = pool;
        this.exchange = exchange;
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.closeSetter));
        delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.writeSetter));
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    private int processWrite(int state) throws IOException {
        int res;
        if (state == 1) {
            this.pooledBuffer = this.pool.allocate();
        }
        ByteBuffer buffer = (ByteBuffer)this.pooledBuffer.getResource();
        Iterator<String> nameIterator = this.nameIterator;
        Iterator<String> valueIterator = this.valueIterator;
        int charIndex = this.charIndex;
        String string = this.string;
        String headerName = this.headerName;
        if (state != 1 && buffer.hasRemaining()) {
            log.trace((Object)"Flushing remaining buffer");
            do {
                if ((res = this.delegate.write(buffer)) != 0) continue;
                return state;
            } while (buffer.hasRemaining());
        }
        buffer.clear();
        block14: while (true) {
            switch (state) {
                case 0: {
                    return state;
                }
                case 1: {
                    log.trace((Object)"Starting response");
                    assert (buffer.remaining() >= 256);
                    string = this.exchange.getProtocol();
                    int length = string.length();
                    for (charIndex = 0; charIndex < length; ++charIndex) {
                        buffer.put((byte)string.charAt(charIndex));
                    }
                    buffer.put((byte)32);
                    int code = this.exchange.getResponseCode();
                    assert (999 >= code && code >= 100);
                    buffer.put((byte)(code / 100 + 48));
                    buffer.put((byte)(code / 10 % 10 + 48));
                    buffer.put((byte)(code % 10 + 48));
                    buffer.put((byte)32);
                    string = "Put Response String Here";
                    length = string.length();
                    for (charIndex = 0; charIndex < length; ++charIndex) {
                        buffer.put((byte)string.charAt(charIndex));
                    }
                    buffer.put((byte)13).put((byte)10);
                    HeaderMap headers = this.exchange.getResponseHeaders();
                    nameIterator = headers.iterator();
                    if (!nameIterator.hasNext()) {
                        log.trace((Object)"No response headers");
                        buffer.put((byte)13).put((byte)10);
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            res = this.delegate.write(buffer);
                            if (res != 0) continue;
                            log.trace((Object)"Continuation");
                            return 10;
                        }
                        this.pooledBuffer.free();
                        this.pooledBuffer = null;
                        log.trace((Object)"Body");
                        return 0;
                    }
                    headerName = nameIterator.next();
                    charIndex = 0;
                }
                case 2: {
                    log.tracef("Processing header '%s'", (Object)headerName);
                    int length = headerName.length();
                    while (charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put((byte)headerName.charAt(charIndex++));
                            continue;
                        }
                        log.trace((Object)"Buffer flush");
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            log.trace((Object)"Continuation");
                            return 2;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                }
                case 3: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            log.trace((Object)"Continuation");
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            return 3;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)58);
                }
                case 4: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            log.trace((Object)"Continuation");
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            return 4;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)32);
                    if (valueIterator == null) {
                        valueIterator = this.exchange.getResponseHeaders().get(headerName).iterator();
                    }
                    assert (valueIterator.hasNext());
                    string = valueIterator.next();
                    charIndex = 0;
                }
                case 5: {
                    log.tracef("Processing header value '%s'", (Object)string);
                    int length = string.length();
                    while (charIndex < length) {
                        if (buffer.hasRemaining()) {
                            buffer.put((byte)string.charAt(charIndex++));
                            continue;
                        }
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            this.string = string;
                            this.headerName = headerName;
                            this.charIndex = charIndex;
                            this.valueIterator = valueIterator;
                            this.nameIterator = nameIterator;
                            log.trace((Object)"Continuation");
                            return 5;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    charIndex = 0;
                    if (!valueIterator.hasNext()) {
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = this.delegate.write(buffer)) != 0) continue;
                                log.trace((Object)"Continuation");
                                return 6;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = this.delegate.write(buffer)) != 0) continue;
                                log.trace((Object)"Continuation");
                                return 7;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)10);
                        if (nameIterator.hasNext()) {
                            headerName = nameIterator.next();
                            valueIterator = null;
                            state = 2;
                            continue block14;
                        }
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = this.delegate.write(buffer)) != 0) continue;
                                log.trace((Object)"Continuation");
                                return 8;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)13);
                        if (!buffer.hasRemaining()) {
                            buffer.flip();
                            do {
                                if ((res = this.delegate.write(buffer)) != 0) continue;
                                log.trace((Object)"Continuation");
                                return 9;
                            } while (buffer.hasRemaining());
                            buffer.clear();
                        }
                        buffer.put((byte)10);
                        this.nameIterator = null;
                        this.valueIterator = null;
                        this.string = null;
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            log.trace((Object)"Continuation");
                            return 10;
                        } while (buffer.hasRemaining());
                        this.pooledBuffer.free();
                        this.pooledBuffer = null;
                        log.trace((Object)"Body");
                        return 0;
                    }
                }
                case 6: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            log.trace((Object)"Continuation");
                            return 6;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)13);
                }
                case 7: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            log.trace((Object)"Continuation");
                            return 7;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)10);
                    if (valueIterator.hasNext()) {
                        state = 2;
                        continue block14;
                    }
                    if (nameIterator.hasNext()) {
                        string = nameIterator.next();
                        valueIterator = null;
                        state = 2;
                        continue block14;
                    }
                }
                case 8: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            log.trace((Object)"Continuation");
                            return 8;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)13);
                }
                case 9: {
                    if (!buffer.hasRemaining()) {
                        buffer.flip();
                        do {
                            if ((res = this.delegate.write(buffer)) != 0) continue;
                            log.trace((Object)"Continuation");
                            return 9;
                        } while (buffer.hasRemaining());
                        buffer.clear();
                    }
                    buffer.put((byte)10);
                    this.nameIterator = null;
                    this.valueIterator = null;
                    this.string = null;
                    buffer.flip();
                    do {
                        if ((res = this.delegate.write(buffer)) != 0) continue;
                        log.trace((Object)"Continuation");
                        return 10;
                    } while (buffer.hasRemaining());
                }
                case 10: {
                    this.pooledBuffer.free();
                    this.pooledBuffer = null;
                    return 0;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        int newVal;
        int oldVal;
        log.trace((Object)"write");
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)16)) continue;
            throw new ConcurrentStreamChannelAccessException();
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x10));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state)) != 0) {
                    int n = 0;
                    return n;
                }
                oldVal = newVal;
                newVal = oldVal & 0xFFFFFFF0 | state;
                while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                    oldVal = this.state;
                    newVal = oldVal & 0xFFFFFFF0 | state;
                }
                if (Bits.allAreSet((int)oldVal, (int)32)) {
                    this.delegate.shutdownWrites();
                    throw new ClosedChannelException();
                }
            }
            int n = this.delegate.write(src);
            return n;
        }
        finally {
            oldVal = newVal;
            newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            }
        }
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        int newVal;
        int oldVal;
        log.trace((Object)"write");
        if (length == 0) {
            return 0L;
        }
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)16)) continue;
            throw new ConcurrentStreamChannelAccessException();
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x10));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state)) != 0) {
                    long l = 0L;
                    return l;
                }
                oldVal = newVal;
                newVal = oldVal & 0xFFFFFFF0 | state;
                while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                    oldVal = this.state;
                    newVal = oldVal & 0xFFFFFFF0 | state;
                }
                if (Bits.allAreSet((int)oldVal, (int)32)) {
                    this.delegate.shutdownWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = length == 1 ? (long)this.delegate.write(srcs[offset]) : this.delegate.write(srcs, offset, length);
            return l;
        }
        finally {
            oldVal = newVal;
            newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        int newVal;
        int oldVal;
        log.trace((Object)"transfer");
        if (count == 0L) {
            return 0L;
        }
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)16)) continue;
            throw new ConcurrentStreamChannelAccessException();
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x10));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state)) != 0) {
                    long l = 0L;
                    return l;
                }
                oldVal = newVal;
                newVal = oldVal & 0xFFFFFFF0 | state;
                while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                    oldVal = this.state;
                    newVal = oldVal & 0xFFFFFFF0 | state;
                }
                if (Bits.allAreSet((int)oldVal, (int)32)) {
                    this.delegate.shutdownWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = this.delegate.transferFrom(src, position, count);
            return l;
        }
        finally {
            oldVal = newVal;
            newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        int newVal;
        int oldVal;
        log.trace((Object)"transfer");
        if (count == 0L) {
            throughBuffer.clear().limit(0);
            return 0L;
        }
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)16)) continue;
            throw new ConcurrentStreamChannelAccessException();
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x10));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state)) != 0) {
                    long l = 0L;
                    return l;
                }
                oldVal = newVal;
                newVal = oldVal & 0xFFFFFFF0 | state;
                while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                    oldVal = this.state;
                    newVal = oldVal & 0xFFFFFFF0 | state;
                }
                if (Bits.allAreSet((int)oldVal, (int)32)) {
                    this.delegate.shutdownWrites();
                    throw new ClosedChannelException();
                }
            }
            long l = this.delegate.transferFrom(source, count, throughBuffer);
            return l;
        }
        finally {
            oldVal = newVal;
            newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        int newVal;
        int oldVal;
        log.trace((Object)"flush");
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)16)) continue;
            log.trace((Object)"Flush false due to reentry");
            return false;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x10));
        int state = oldVal & 0xF;
        try {
            if (state != 0) {
                if ((state = this.processWrite(state)) != 0) {
                    log.tracef("Flush false because headers aren't written yet (%d)", (Object)state);
                    boolean bl = false;
                    return bl;
                }
                oldVal = newVal;
                newVal = oldVal & 0xFFFFFFF0 | state;
                while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                    oldVal = this.state;
                    newVal = oldVal & 0xFFFFFFF0 | state;
                }
                if (Bits.allAreSet((int)oldVal, (int)32)) {
                    this.delegate.shutdownWrites();
                }
            }
            log.trace((Object)"Delegating flush");
            boolean bl = this.delegate.flush();
            return bl;
        }
        finally {
            oldVal = newVal;
            newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xFFFFFFEF & 0xFFFFFFF0 | state;
            }
        }
    }

    public void suspendWrites() {
        log.trace((Object)"suspend");
        this.delegate.suspendWrites();
    }

    public void resumeWrites() {
        log.trace((Object)"resume");
        this.delegate.resumeWrites();
    }

    public boolean isWriteResumed() {
        return this.delegate.isWriteResumed();
    }

    public void wakeupWrites() {
        log.trace((Object)"wakeup");
        this.delegate.wakeupWrites();
    }

    public void shutdownWrites() throws IOException {
        int newVal;
        int oldVal;
        log.trace((Object)"shutdown");
        do {
            if (!Bits.allAreClear((int)(oldVal = this.state), (int)15)) continue;
            this.delegate.shutdownWrites();
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x20));
    }

    public void awaitWritable() throws IOException {
        this.delegate.awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitWritable(time, timeUnit);
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int newVal;
        int oldVal;
        log.trace((Object)"close");
        do {
            if (!Bits.allAreClear((int)(oldVal = this.state), (int)15)) continue;
            try {
                this.delegate.close();
            }
            finally {
                if (this.pooledBuffer != null) {
                    this.pooledBuffer.free();
                    this.pooledBuffer = null;
                }
            }
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & 0xFFFFFFF0 | 0x20 | 0));
        IoUtils.safeClose((Closeable)this.delegate);
        throw new TruncatedResponseException();
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.delegate.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.delegate.setOption(option, value);
    }
}

