/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpHandler;
import io.undertow.util.AbstractAttachable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedStreamChannel;

public final class HttpServerConnection
extends AbstractAttachable
implements ConnectedChannel {
    private final ConnectedStreamChannel channel;
    private final ChannelListener.Setter<HttpServerConnection> closeSetter;
    private final Pool<ByteBuffer> bufferPool;
    private final HttpHandler rootHandler;
    private final int maxConcurrentRequests;
    private volatile int runningRequestCount;
    private static final AtomicIntegerFieldUpdater<HttpServerConnection> runningRequestCountUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpServerConnection.class, "runningRequestCount");

    HttpServerConnection(ConnectedStreamChannel channel, Pool<ByteBuffer> bufferPool, HttpHandler rootHandler, int maxConcurrentRequests) {
        this.channel = channel;
        this.bufferPool = bufferPool;
        this.rootHandler = rootHandler;
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.closeSetter = ChannelListeners.getDelegatingSetter((ChannelListener.Setter)channel.getCloseSetter(), (Channel)((Object)this));
    }

    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    public ConnectedStreamChannel getChannel() {
        return this.channel;
    }

    public ChannelListener.Setter<HttpServerConnection> getCloseSetter() {
        return this.closeSetter;
    }

    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.channel.setOption(option, value);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.channel.getPeerAddress(type);
    }

    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.channel.getLocalAddress(type);
    }

    public boolean startRequest() {
        int running;
        do {
            if ((running = runningRequestCountUpdater.get(this)) != this.maxConcurrentRequests) continue;
            return false;
        } while (!runningRequestCountUpdater.compareAndSet(this, running, running + 1));
        return true;
    }

    public void requestFinished() {
        runningRequestCountUpdater.decrementAndGet(this);
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }
}

