/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.server.ChannelWrapper;
import io.undertow.server.HttpResponseChannel;
import io.undertow.server.HttpServerConnection;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ChannelFactory;
import org.xnio.channels.Channels;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableReadChannel;

public final class HttpServerExchange
extends AbstractAttachable {
    private static final Logger log = Logger.getLogger(HttpServerExchange.class);
    private final HttpServerConnection connection;
    private final HeaderMap requestHeaders;
    private final HeaderMap responseHeaders;
    private final Map<String, Deque<String>> queryParameters;
    private final StreamSinkChannel underlyingResponseChannel;
    private final StreamSourceChannel underlyingRequestChannel;
    private final Runnable requestTerminateAction;
    private final Runnable responseTerminateAction;
    private final String protocol;
    private volatile int state = 200;
    private volatile String requestMethod;
    private volatile String requestScheme;
    private volatile String requestURI;
    private volatile String requestPath;
    private volatile String canonicalPath;
    private volatile String relativePath;
    private volatile String resolvedPath = "/";
    private static final ChannelWrapper<StreamSourceChannel>[] NO_SOURCE_WRAPPERS = new ChannelWrapper[0];
    private static final ChannelWrapper<StreamSinkChannel>[] NO_SINK_WRAPPERS = new ChannelWrapper[0];
    private volatile ChannelWrapper[] requestWrappers = NO_SOURCE_WRAPPERS;
    private volatile ChannelWrapper[] responseWrappers = NO_SINK_WRAPPERS;
    private static final AtomicReferenceFieldUpdater<HttpServerExchange, ChannelWrapper[]> requestWrappersUpdater = AtomicReferenceFieldUpdater.newUpdater(HttpServerExchange.class, ChannelWrapper[].class, "requestWrappers");
    private static final AtomicReferenceFieldUpdater<HttpServerExchange, ChannelWrapper[]> responseWrappersUpdater = AtomicReferenceFieldUpdater.newUpdater(HttpServerExchange.class, ChannelWrapper[].class, "responseWrappers");
    private static final AtomicIntegerFieldUpdater<HttpServerExchange> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpServerExchange.class, "state");
    private static final int MASK_RESPONSE_CODE = Bits.intBitMask((int)0, (int)9);
    private static final int FLAG_RESPONSE_SENT = 1024;
    private static final int FLAG_RESPONSE_TERMINATED = 2048;
    private static final int FLAG_REQUEST_TERMINATED = 4096;
    private static final int FLAG_CLEANUP = 8192;

    HttpServerExchange(HttpServerConnection connection, HeaderMap requestHeaders, HeaderMap responseHeaders, Map<String, Deque<String>> queryParameters, String requestMethod, String protocol, StreamSourceChannel requestChannel, StreamSinkChannel responseChannel, Runnable requestTerminateAction, Runnable responseTerminateAction) {
        this.connection = connection;
        this.requestHeaders = requestHeaders;
        this.responseHeaders = responseHeaders;
        this.queryParameters = queryParameters;
        this.requestMethod = requestMethod;
        this.protocol = protocol;
        this.underlyingRequestChannel = requestChannel;
        this.underlyingResponseChannel = new HttpResponseChannel(responseChannel, connection.getBufferPool(), this);
        this.requestTerminateAction = requestTerminateAction;
        this.responseTerminateAction = responseTerminateAction;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isHttp09() {
        return this.protocol.equals("HTTP/0.9");
    }

    public boolean isHttp10() {
        return this.protocol.equals("HTTP/1.0");
    }

    public boolean isHttp11() {
        return this.protocol.equals("HTTP/1.1");
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getRequestScheme() {
        return this.requestScheme;
    }

    public void setRequestScheme(String requestScheme) {
        this.requestScheme = requestScheme;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public void setResolvedPath(String resolvedPath) {
        this.resolvedPath = resolvedPath;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public void setCanonicalPath(String canonicalPath) {
        this.canonicalPath = canonicalPath;
    }

    public HttpServerConnection getConnection() {
        return this.connection;
    }

    public ConnectedStreamChannel upgradeChannel() throws IllegalStateException, IOException {
        this.setResponseCode(101);
        return new AssembledConnectedStreamChannel(this.getRequestChannel(), (StreamSinkChannel)this.getResponseChannelFactory().create());
    }

    public InetSocketAddress getSourceAddress() {
        return this.connection.getPeerAddress(InetSocketAddress.class);
    }

    public InetSocketAddress getDestinationAddress() {
        return this.connection.getLocalAddress(InetSocketAddress.class);
    }

    public HeaderMap getRequestHeaders() {
        return this.requestHeaders;
    }

    public HeaderMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Deque<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public boolean isResponseStarted() {
        return Bits.allAreSet((int)this.state, (int)1024);
    }

    public StreamSourceChannel getRequestChannel() {
        ChannelWrapper[] wrappers = requestWrappersUpdater.getAndSet(this, null);
        if (wrappers == null) {
            return null;
        }
        StreamSourceChannel channel = this.underlyingRequestChannel;
        for (ChannelWrapper wrapper : wrappers) {
            StreamSourceChannel oldChannel = channel;
            if ((channel = wrapper.wrap(oldChannel, this)) != null) continue;
            channel = oldChannel;
        }
        return channel;
    }

    public boolean isRequestChannelAvailable() {
        return this.requestWrappers != null;
    }

    StreamSourceChannel getUnderlyingRequestChannel() {
        return this.underlyingRequestChannel;
    }

    void terminateRequest() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)4096)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x1000));
        this.requestTerminateAction.run();
    }

    public ChannelFactory<StreamSinkChannel> getResponseChannelFactory() {
        ChannelWrapper[] wrappers = responseWrappersUpdater.getAndSet(this, null);
        if (wrappers == null) {
            return null;
        }
        return new ResponseChannelFactory(this, this.underlyingResponseChannel, wrappers);
    }

    public boolean isResponseChannelAvailable() {
        return this.responseWrappers != null;
    }

    public void setResponseCode(int responseCode) {
        int newVal;
        int oldVal;
        if (responseCode < 0 || responseCode > 999) {
            throw new IllegalArgumentException("Invalid response code");
        }
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)1024)) continue;
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & ~MASK_RESPONSE_CODE | responseCode & MASK_RESPONSE_CODE));
    }

    public void addRequestWrapper(ChannelWrapper<StreamSourceChannel> wrapper) {
        ChannelWrapper[] newVal;
        ChannelWrapper[] oldVal;
        do {
            if ((oldVal = this.requestWrappers) == null) {
                throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
            }
            int oldLen = oldVal.length;
            newVal = Arrays.copyOf(oldVal, oldLen + 1);
            newVal[oldLen] = wrapper;
        } while (!requestWrappersUpdater.compareAndSet(this, oldVal, newVal));
    }

    public void addResponseWrapper(ChannelWrapper<StreamSinkChannel> wrapper) {
        ChannelWrapper[] newVal;
        ChannelWrapper[] oldVal;
        do {
            if ((oldVal = this.responseWrappers) == null) {
                throw UndertowMessages.MESSAGES.responseChannelAlreadyProvided();
            }
            int oldLen = oldVal.length;
            newVal = Arrays.copyOf(oldVal, oldLen + 1);
            newVal[oldLen] = wrapper;
        } while (!responseWrappersUpdater.compareAndSet(this, oldVal, newVal));
    }

    public int getResponseCode() {
        return this.state & MASK_RESPONSE_CODE;
    }

    void terminateResponse() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)2048)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x800));
        this.responseTerminateAction.run();
    }

    void startResponse() throws IllegalStateException {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)1024)) continue;
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x400));
        log.tracef("Starting to write response for %s using channel %s", (Object)this, (Object)this.underlyingResponseChannel);
        HeaderMap responseHeaders = this.responseHeaders;
        responseHeaders.lock();
    }

    void cleanup() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet((int)(oldVal = this.state), (int)8192)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 0x2000 | 0x1000 | 0x800));
        StreamSourceChannel requestChannel = this.underlyingRequestChannel;
        StreamSinkChannel responseChannel = this.underlyingResponseChannel;
        if (Bits.allAreSet((int)oldVal, (int)6144)) {
            return;
        }
        try {
            long res;
            while ((res = Channels.drain((StreamSourceChannel)requestChannel, (long)Long.MAX_VALUE)) > 0L) {
            }
            if (res == 0L) {
                requestChannel.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)new ChannelListener<SuspendableReadChannel>(){

                    public void handleEvent(SuspendableReadChannel channel) {
                        channel.suspendReads();
                        channel.getReadSetter().set(null);
                        IoUtils.safeShutdownReads((SuspendableReadChannel)channel);
                    }
                }, (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
                requestChannel.resumeReads();
            } else {
                assert (res == -1L);
                requestChannel.shutdownReads();
            }
            responseChannel.shutdownWrites();
            if (!responseChannel.flush()) {
                responseChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                    public void handleEvent(StreamSinkChannel channel) {
                        channel.suspendWrites();
                        channel.getWriteSetter().set(null);
                    }
                }, (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
                responseChannel.resumeWrites();
            }
        }
        catch (Throwable t) {
            IoUtils.safeClose((Closeable)requestChannel);
            IoUtils.safeClose((Closeable)responseChannel);
            IoUtils.safeClose((Closeable)((Object)this.connection));
        }
    }

    private static final class ResponseChannelFactory
    implements ChannelFactory<StreamSinkChannel> {
        private static final AtomicReferenceFieldUpdater<ResponseChannelFactory, ChannelWrapper[]> wrappersUpdater = AtomicReferenceFieldUpdater.newUpdater(ResponseChannelFactory.class, ChannelWrapper[].class, "wrappers");
        private final HttpServerExchange exchange;
        private final StreamSinkChannel firstChannel;
        private volatile ChannelWrapper[] wrappers;

        ResponseChannelFactory(HttpServerExchange exchange, StreamSinkChannel firstChannel, ChannelWrapper[] wrappers) {
            this.exchange = exchange;
            this.firstChannel = firstChannel;
            this.wrappers = wrappers;
        }

        public StreamSinkChannel create() {
            StreamSinkChannel oldChannel;
            ChannelWrapper[] wrappers = wrappersUpdater.getAndSet(this, null);
            if (wrappers == null) {
                return null;
            }
            StreamSinkChannel channel = oldChannel = this.firstChannel;
            for (ChannelWrapper wrapper : wrappers) {
                channel = wrapper.wrap(oldChannel, this.exchange);
                if (channel != null) continue;
                channel = oldChannel;
            }
            this.exchange.startResponse();
            return channel;
        }
    }
}

