/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.ChannelWrapper;
import io.undertow.server.FinishableStreamSinkChannel;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.ChunkedStreamSinkChannel;
import io.undertow.util.ChunkedStreamSourceChannel;
import io.undertow.util.HeaderMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.ChannelFactory;
import org.xnio.channels.EmptyStreamSourceChannel;
import org.xnio.channels.FixedLengthStreamSinkChannel;
import org.xnio.channels.FixedLengthStreamSourceChannel;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class HttpTransferEncodingHandler
implements HttpHandler {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.handler.transfer-encoding");
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    public HttpTransferEncodingHandler() {
    }

    public HttpTransferEncodingHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        boolean persistentConnection;
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        boolean hasConnectionHeader = requestHeaders.contains("Connection");
        boolean hasTransferEncoding = requestHeaders.contains("Transfer-Encoding");
        boolean hasContentLength = requestHeaders.contains("Content-Length");
        if (exchange.isHttp11()) {
            persistentConnection = !hasConnectionHeader || !requestHeaders.getFirst("Connection").equalsIgnoreCase("close");
        } else if (exchange.isHttp10()) {
            persistentConnection = false;
            if (hasConnectionHeader) {
                for (String value : requestHeaders.get("Connection")) {
                    if (!value.equalsIgnoreCase("keep-alive")) continue;
                    persistentConnection = true;
                    break;
                }
            }
        } else {
            log.trace((Object)"Connection not persistent");
            persistentConnection = false;
        }
        CompletionHandler ourCompletionHandler = new CompletionHandler(exchange, completionHandler);
        String transferEncoding = "identity";
        if (hasTransferEncoding) {
            transferEncoding = requestHeaders.getLast("Transfer-Encoding");
        }
        if (!transferEncoding.equalsIgnoreCase("identity")) {
            exchange.addRequestWrapper(HttpTransferEncodingHandler.chunkedStreamSourceChannelWrapper(ourCompletionHandler));
        } else if (hasContentLength) {
            long contentLength;
            try {
                contentLength = Long.parseLong(requestHeaders.get("Content-Length").getFirst());
            }
            catch (NumberFormatException e) {
                log.trace((Object)"Invalid request due to unparsable content length");
                exchange.setResponseCode(400);
                completionHandler.handleComplete();
                return;
            }
            if (contentLength == 0L) {
                log.trace((Object)"No content, starting next request");
                exchange.addRequestWrapper(HttpTransferEncodingHandler.emptyStreamSourceChannelWrapper());
                exchange.terminateRequest();
            } else if (persistentConnection) {
                exchange.addRequestWrapper(HttpTransferEncodingHandler.fixedLengthStreamSourceChannelWrapper(ourCompletionHandler, contentLength));
            }
        } else if (hasTransferEncoding) {
            if (transferEncoding.equalsIgnoreCase("identity")) {
                log.trace((Object)"Connection not persistent (no content length and identity transfer encoding)");
                persistentConnection = false;
            }
        } else if (persistentConnection) {
            exchange.terminateRequest();
            exchange.addRequestWrapper(HttpTransferEncodingHandler.emptyStreamSourceChannelWrapper());
        }
        exchange.addResponseWrapper(HttpTransferEncodingHandler.responseWrapper(ourCompletionHandler, persistentConnection));
        HttpHandlers.executeHandler(this.next, exchange, ourCompletionHandler);
    }

    private static ChannelWrapper<StreamSinkChannel> responseWrapper(final CompletionHandler ourCompletionHandler, final boolean requestLooksPersistent) {
        return new ChannelWrapper<StreamSinkChannel>(){

            @Override
            public StreamSinkChannel wrap(StreamSinkChannel channel, HttpServerExchange exchange) {
                Object wrappedChannel;
                HeaderMap responseHeaders = exchange.getResponseHeaders();
                boolean stillPersistent = requestLooksPersistent;
                String transferEncoding = "identity";
                if (responseHeaders.contains("Transfer-Encoding")) {
                    if (exchange.isHttp11()) {
                        transferEncoding = responseHeaders.getLast("Transfer-Encoding");
                    } else {
                        responseHeaders.remove("Transfer-Encoding");
                    }
                } else if (exchange.isHttp11() && !responseHeaders.contains("Content-Length")) {
                    responseHeaders.put("Transfer-Encoding", "chunked");
                    transferEncoding = "chunked";
                }
                int code = exchange.getResponseCode();
                if (exchange.getRequestMethod().equalsIgnoreCase("HEAD") || 100 <= code && code <= 199 || code == 204 || code == 304) {
                    ChannelListener finishListener = stillPersistent ? HttpTransferEncodingHandler.terminateResponseListener(exchange) : null;
                    wrappedChannel = new FixedLengthStreamSinkChannel(channel, 0L, false, !stillPersistent, finishListener, null);
                } else if (!transferEncoding.equalsIgnoreCase("identity")) {
                    ChannelListener finishListener = stillPersistent ? HttpTransferEncodingHandler.terminateResponseListener(exchange) : null;
                    wrappedChannel = new ChunkedStreamSinkChannel(channel, false, !stillPersistent, (ChannelListener<? super ChunkedStreamSinkChannel>)finishListener, exchange.getConnection().getBufferPool());
                } else if (responseHeaders.contains("Content-Length")) {
                    try {
                        long contentLength = Long.parseLong(responseHeaders.get("Content-Length").getFirst());
                        ChannelListener finishListener = stillPersistent ? HttpTransferEncodingHandler.terminateResponseListener(exchange) : null;
                        wrappedChannel = new FixedLengthStreamSinkChannel(channel, contentLength, false, !stillPersistent, finishListener, null);
                    }
                    catch (NumberFormatException e) {
                        stillPersistent = false;
                        wrappedChannel = new FinishableStreamSinkChannel(channel, (ChannelListener<? super FinishableStreamSinkChannel>)HttpTransferEncodingHandler.terminateResponseListener(exchange));
                    }
                } else {
                    log.trace((Object)"Cancelling persistence because response is identity with no content length");
                    stillPersistent = false;
                    wrappedChannel = new FinishableStreamSinkChannel(channel, (ChannelListener<? super FinishableStreamSinkChannel>)HttpTransferEncodingHandler.terminateResponseListener(exchange));
                }
                if (exchange.isHttp11()) {
                    if (stillPersistent) {
                        responseHeaders.put("Connection", "keep-alive");
                    } else {
                        responseHeaders.put("Connection", "close");
                    }
                } else if (exchange.isHttp10()) {
                    if (stillPersistent) {
                        responseHeaders.put("Connection", "keep-alive");
                    } else {
                        responseHeaders.remove("Connection");
                    }
                }
                return ourCompletionHandler.setResponseStream((StreamSinkChannel)wrappedChannel);
            }
        };
    }

    private static ChannelWrapper<StreamSourceChannel> chunkedStreamSourceChannelWrapper(final CompletionHandler ourCompletionHandler) {
        return new ChannelWrapper<StreamSourceChannel>(){

            @Override
            public StreamSourceChannel wrap(StreamSourceChannel channel, HttpServerExchange exchange) {
                return ourCompletionHandler.setRequestStream(new ChunkedStreamSourceChannel((PushBackStreamChannel)channel, (ChannelListener<? super ChunkedStreamSourceChannel>)HttpTransferEncodingHandler.chunkedDrainListener(channel, exchange), exchange.getConnection().getBufferPool()));
            }
        };
    }

    private static ChannelWrapper<StreamSourceChannel> fixedLengthStreamSourceChannelWrapper(final CompletionHandler ourCompletionHandler, final long contentLength) {
        return new ChannelWrapper<StreamSourceChannel>(){

            @Override
            public StreamSourceChannel wrap(StreamSourceChannel channel, HttpServerExchange exchange) {
                return ourCompletionHandler.setRequestStream((StreamSourceChannel)new FixedLengthStreamSourceChannel(channel, contentLength, false, HttpTransferEncodingHandler.fixedLengthDrainListener(channel, exchange), null));
            }
        };
    }

    private static ChannelWrapper<StreamSourceChannel> emptyStreamSourceChannelWrapper() {
        return new ChannelWrapper<StreamSourceChannel>(){

            @Override
            public StreamSourceChannel wrap(StreamSourceChannel channel, HttpServerExchange exchange) {
                return new EmptyStreamSourceChannel(channel.getWorker(), channel.getReadThread());
            }
        };
    }

    private static ChannelListener<FixedLengthStreamSourceChannel> fixedLengthDrainListener(final StreamSourceChannel channel, final HttpServerExchange exchange) {
        return new ChannelListener<FixedLengthStreamSourceChannel>(){

            public void handleEvent(FixedLengthStreamSourceChannel fixedLengthChannel) {
                long remaining = fixedLengthChannel.getRemaining();
                if (remaining > 0L) {
                    channel.getReadSetter().set(ChannelListeners.drainListener((long)remaining, (ChannelListener)HttpTransferEncodingHandler.terminateRequestListener(exchange), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
                    channel.resumeReads();
                    return;
                }
                exchange.terminateRequest();
            }
        };
    }

    private static ChannelListener<ChunkedStreamSourceChannel> chunkedDrainListener(final StreamSourceChannel channel, final HttpServerExchange exchange) {
        return new ChannelListener<ChunkedStreamSourceChannel>(){

            public void handleEvent(ChunkedStreamSourceChannel chunkedStreamSourceChannel) {
                channel.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)HttpTransferEncodingHandler.terminateRequestListener(exchange), (ChannelExceptionHandler)ChannelListeners.closingChannelExceptionHandler()));
            }
        };
    }

    private static ChannelListener<StreamSinkChannel> terminateResponseListener(final HttpServerExchange exchange) {
        return new ChannelListener<StreamSinkChannel>(){

            public void handleEvent(StreamSinkChannel channel) {
                exchange.terminateResponse();
            }
        };
    }

    private static ChannelListener<StreamSourceChannel> terminateRequestListener(final HttpServerExchange exchange) {
        return new ChannelListener<StreamSourceChannel>(){

            public void handleEvent(StreamSourceChannel channel) {
                exchange.terminateRequest();
            }
        };
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public void setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
    }

    private static final class CompletionHandler
    implements HttpCompletionHandler {
        private final HttpServerExchange exchange;
        private final HttpCompletionHandler delegate;
        private volatile StreamSourceChannel requestStream;
        private volatile StreamSinkChannel responseStream;
        private volatile int called;
        private static final AtomicIntegerFieldUpdater<CompletionHandler> calledUpdater = AtomicIntegerFieldUpdater.newUpdater(CompletionHandler.class, "called");

        private CompletionHandler(HttpServerExchange exchange, HttpCompletionHandler delegate) {
            this.exchange = exchange;
            this.delegate = delegate;
        }

        public StreamSourceChannel setRequestStream(StreamSourceChannel requestStream) {
            this.requestStream = requestStream;
            return this.requestStream;
        }

        public StreamSinkChannel setResponseStream(StreamSinkChannel responseStream) {
            this.responseStream = responseStream;
            return this.responseStream;
        }

        @Override
        public void handleComplete() {
            if (!calledUpdater.compareAndSet(this, 0, 1)) {
                return;
            }
            this.exchange.getRequestChannel();
            ChannelFactory<StreamSinkChannel> factory = this.exchange.getResponseChannelFactory();
            if (factory != null) {
                this.exchange.getResponseHeaders().put("Content-Length", "0");
                factory.create();
            }
            IoUtils.safeClose((Closeable)this.requestStream);
            try {
                this.responseStream.shutdownWrites();
                if (this.responseStream.flush()) {
                    this.delegate.handleComplete();
                    return;
                }
                this.responseStream.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<SuspendableWriteChannel>(){

                    public void handleEvent(SuspendableWriteChannel channel) {
                        CompletionHandler.this.delegate.handleComplete();
                    }
                }, (ChannelExceptionHandler)new ChannelExceptionHandler<Channel>(){

                    public void handleException(Channel channel, IOException exception) {
                        CompletionHandler.this.delegate.handleComplete();
                    }
                }));
                this.responseStream.resumeWrites();
                return;
            }
            catch (Throwable e) {
                IoUtils.safeClose((Closeable)this.responseStream);
                this.delegate.handleComplete();
                return;
            }
        }
    }
}

