/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Cookie {
    public static final AttachmentKey<Map<String, Cookie>> REQUEST_COOKIES = AttachmentKey.create(Map.class);
    public static final AttachmentKey<AttachmentList<Cookie>> RESPONSE_COOKIES = AttachmentKey.createList(Cookie.class);
    private final String name;
    private volatile String value;
    private volatile String path;
    private volatile String domain;
    private volatile Integer maxAge;
    private volatile Date expires;
    private volatile boolean discard;
    private volatile boolean secure;
    private volatile boolean httpOnly;
    private volatile int version = 0;

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(String name) {
        this.name = name;
    }

    public static Map<String, Cookie> getRequestCookies(HttpServerExchange exchange) {
        return exchange.getAttachment(REQUEST_COOKIES);
    }

    public static List<Cookie> getResponseCookies(HttpServerExchange exchange) {
        return exchange.getAttachment(RESPONSE_COOKIES);
    }

    public static void addResponseCookie(HttpServerExchange exchange, Cookie cookie) {
        List cookies = exchange.getAttachment(RESPONSE_COOKIES);
        if (cookies == null) {
            throw UndertowMessages.MESSAGES.cookieHandlerNotPresent();
        }
        cookies.add(cookie);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Cookie setValue(String value) {
        this.value = value;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public Cookie setPath(String path) {
        this.path = path;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public Cookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public Cookie setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public Cookie setDiscard(boolean discard) {
        this.discard = discard;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Cookie setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public Cookie setVersion(int version) {
        this.version = version;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Cookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public Date getExpires() {
        return this.expires;
    }

    public Cookie setExpires(Date expires) {
        this.expires = expires;
        return this;
    }
}

