/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.blocking.BlockingHttpHandler;

public final class HttpHandlers {
    public static void executeHandler(HttpHandler handler, HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        try {
            handler.handleRequest(exchange, completionHandler);
        }
        catch (Throwable t) {
            try {
                exchange.setResponseCode(500);
                completionHandler.handleComplete();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    public static void handlerNotNull(HttpHandler handler) {
        if (handler == null) {
            throw UndertowMessages.MESSAGES.handlerCannotBeNull();
        }
    }

    public static void handlerNotNull(BlockingHttpHandler handler) {
        if (handler == null) {
            throw UndertowMessages.MESSAGES.handlerCannotBeNull();
        }
    }
}

