/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class OriginHandler
implements HttpHandler {
    private volatile HttpHandler originFailedHandler = ResponseCodeHandler.HANDLE_403;
    private volatile Set<String> allowedOrigins = new HashSet<String>();
    private volatile boolean requireAllOrigins = true;
    private volatile boolean requireOriginHeader = true;
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        Deque<String> origin = exchange.getRequestHeaders().get("Origin");
        if (origin == null) {
            if (this.requireOriginHeader) {
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Refusing request for %s due to lack of Origin: header", exchange.getRequestPath());
                }
                HttpHandlers.executeHandler(this.originFailedHandler, exchange, completionHandler);
                return;
            }
        } else {
            boolean found = false;
            boolean requireAllOrigins = this.requireAllOrigins;
            for (String header : origin) {
                if (this.allowedOrigins.contains(header)) {
                    found = true;
                    if (requireAllOrigins) continue;
                    break;
                }
                if (!requireAllOrigins) continue;
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Refusing request for %s due to Origin %s not being in the allowed origins list", exchange.getRequestPath(), header);
                }
                HttpHandlers.executeHandler(this.originFailedHandler, exchange, completionHandler);
                return;
            }
            if (!found) {
                if (UndertowLogger.REQUEST_LOGGER.isDebugEnabled()) {
                    UndertowLogger.REQUEST_LOGGER.debugf("Refusing request for %s as none of the specified origins %s were in the allowed origins list", exchange.getRequestPath(), origin);
                }
                HttpHandlers.executeHandler(this.originFailedHandler, exchange, completionHandler);
                return;
            }
        }
        HttpHandlers.executeHandler(this.next, exchange, completionHandler);
    }

    public synchronized void addAllowedOrigin(String origin) {
        HashSet<String> allowedOrigins = new HashSet<String>(this.allowedOrigins);
        allowedOrigins.add(origin);
        this.allowedOrigins = Collections.unmodifiableSet(allowedOrigins);
    }

    public synchronized void addAllowedOrigins(Collection<String> origins) {
        HashSet<String> allowedOrigins = new HashSet<String>(this.allowedOrigins);
        allowedOrigins.addAll(origins);
        this.allowedOrigins = Collections.unmodifiableSet(allowedOrigins);
    }

    public synchronized void addAllowedOrigins(String ... origins) {
        HashSet<String> allowedOrigins = new HashSet<String>(this.allowedOrigins);
        allowedOrigins.addAll(Arrays.asList(origins));
        this.allowedOrigins = Collections.unmodifiableSet(allowedOrigins);
    }

    public synchronized Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public synchronized void clearAllowedOrigins() {
        this.allowedOrigins = Collections.emptySet();
    }

    public boolean isRequireAllOrigins() {
        return this.requireAllOrigins;
    }

    public void setRequireAllOrigins(boolean requireAllOrigins) {
        this.requireAllOrigins = requireAllOrigins;
    }

    public boolean isRequireOriginHeader() {
        return this.requireOriginHeader;
    }

    public void setRequireOriginHeader(boolean requireOriginHeader) {
        this.requireOriginHeader = requireOriginHeader;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public void setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
    }

    public HttpHandler getOriginFailedHandler() {
        return this.originFailedHandler;
    }

    public void setOriginFailedHandler(HttpHandler originFailedHandler) {
        HttpHandlers.handlerNotNull(originFailedHandler);
        this.originFailedHandler = originFailedHandler;
    }
}

