/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class PathHandler
implements HttpHandler {
    private volatile HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;
    private final ConcurrentMap<String, HttpHandler> paths = new CopyOnWriteMap<String, HttpHandler>();

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        int pos;
        String path = exchange.getRelativePath();
        int length = path.length();
        for (pos = 0; pos < length && (path.charAt(pos) != '/' || pos == 0); ++pos) {
        }
        String part = path.substring(0, pos);
        HttpHandler next = (HttpHandler)this.paths.get(part);
        if (next != null) {
            exchange.setRelativePath(path.substring(pos));
            exchange.setResolvedPath(exchange.getResolvedPath() + part);
            HttpHandlers.executeHandler(next, exchange, completionHandler);
        } else {
            HttpHandlers.executeHandler(this.defaultHandler, exchange, completionHandler);
        }
    }

    public HttpHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(HttpHandler defaultHandler) {
        HttpHandlers.handlerNotNull(defaultHandler);
        this.defaultHandler = defaultHandler;
    }

    public void addPath(String path, HttpHandler handler) {
        HttpHandlers.handlerNotNull(handler);
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.charAt(0) != '/') {
            this.paths.put("/" + path, handler);
        } else {
            this.paths.put(path, handler);
        }
    }

    public void removePath(String path) {
        if (path == null || path.isEmpty()) {
            throw UndertowMessages.MESSAGES.pathMustBeSpecified();
        }
        if (path.charAt(0) != '/') {
            this.paths.remove("/" + path);
        } else {
            this.paths.remove(path);
        }
    }

    public void clearPaths() {
        this.paths.clear();
    }

    public Map<String, HttpHandler> getPaths() {
        return Collections.unmodifiableMap(this.paths);
    }
}

