/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.xnio.Bits;

public final class RequestLimitingHandler
implements HttpHandler {
    private volatile long state;
    private volatile HttpHandler nextHandler = ResponseCodeHandler.HANDLE_404;
    private static final AtomicLongFieldUpdater<RequestLimitingHandler> stateUpdater;
    private static final AtomicReferenceFieldUpdater<RequestLimitingHandler, HttpHandler> nextHandlerUpdater;
    private static final long MASK_MAX;
    private static final long MASK_CURRENT;
    private final Queue<QueuedRequest> queue;
    private static final Class<Queue> linkedTransferQueue;

    public RequestLimitingHandler(int maximumConcurrentRequests, HttpHandler nextHandler) {
        Queue queue;
        if (nextHandler == null) {
            throw new IllegalArgumentException("nextHandler is null");
        }
        if (maximumConcurrentRequests < 1) {
            throw new IllegalArgumentException("Maximum concurrent requests must be at least 1");
        }
        this.state = ((long)maximumConcurrentRequests & 0xFFFFFFFFL) << 32;
        this.nextHandler = nextHandler;
        if (linkedTransferQueue == null) {
            queue = new ConcurrentLinkedQueue();
        } else {
            try {
                queue = linkedTransferQueue.newInstance();
            }
            catch (Throwable t) {
                queue = new ConcurrentLinkedQueue();
            }
        }
        this.queue = queue;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        long newVal;
        long oldVal;
        do {
            long max;
            long current;
            if ((current = (oldVal = this.state) & MASK_CURRENT) < (max = (oldVal & MASK_MAX) >> 32)) continue;
            this.queue.add(new QueuedRequest(exchange, completionHandler));
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal + 1L));
        HttpHandlers.executeHandler(this.nextHandler, exchange, new CompletionHandler(completionHandler, exchange));
    }

    public int getMaximumConcurrentRequests() {
        return (int)(this.state >> 32);
    }

    public int setMaximumConcurrentRequests(int newMax) {
        int oldMax;
        int current;
        long newVal;
        long oldVal;
        if (newMax < 1) {
            throw new IllegalArgumentException("Maximum concurrent requests must be at least 1");
        }
        do {
            oldVal = this.state;
            current = (int)(oldVal & MASK_CURRENT);
            oldMax = (int)((oldVal & MASK_MAX) >> 32);
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = (long)current | (long)newMax & 0xFFFFFFFF00000000L));
        while (current < newMax) {
            QueuedRequest request = this.queue.poll();
            if (request == null) continue;
            newVal = stateUpdater.getAndIncrement(this);
            current = (int)(newVal & MASK_CURRENT);
            request.exchange.getConnection().getWorker().execute((Runnable)request);
        }
        return oldMax;
    }

    private void decrementRequests() {
        stateUpdater.decrementAndGet(this);
    }

    public HttpHandler getNextHandler() {
        return this.nextHandler;
    }

    public HttpHandler setNextHandler(HttpHandler nextHandler) {
        HttpHandlers.handlerNotNull(nextHandler);
        return nextHandlerUpdater.getAndSet(this, nextHandler);
    }

    static {
        Class<?> q;
        stateUpdater = AtomicLongFieldUpdater.newUpdater(RequestLimitingHandler.class, "state");
        nextHandlerUpdater = AtomicReferenceFieldUpdater.newUpdater(RequestLimitingHandler.class, HttpHandler.class, "nextHandler");
        MASK_MAX = Bits.longBitMask((int)32, (int)63);
        MASK_CURRENT = Bits.longBitMask((int)0, (int)30);
        try {
            q = Class.forName("java.util.concurrent.LinkedTransferQueue");
        }
        catch (ClassNotFoundException e) {
            q = null;
        }
        linkedTransferQueue = q;
    }

    private class CompletionHandler
    extends AtomicBoolean
    implements HttpCompletionHandler {
        private final HttpCompletionHandler completionHandler;
        private final HttpServerExchange exchange;

        public CompletionHandler(HttpCompletionHandler completionHandler, HttpServerExchange exchange) {
            this.completionHandler = completionHandler;
            this.exchange = exchange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleComplete() {
            if (!this.compareAndSet(false, true)) {
                return;
            }
            try {
                this.completionHandler.handleComplete();
            }
            finally {
                QueuedRequest task = (QueuedRequest)RequestLimitingHandler.this.queue.poll();
                if (task != null) {
                    this.exchange.getConnection().getWorker().execute((Runnable)task);
                } else {
                    RequestLimitingHandler.this.decrementRequests();
                }
            }
        }
    }

    private final class QueuedRequest
    implements Runnable {
        private final HttpServerExchange exchange;
        private final HttpCompletionHandler completionHandler;

        QueuedRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
            this.exchange = exchange;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run() {
            HttpHandlers.executeHandler(RequestLimitingHandler.this.nextHandler, this.exchange, new CompletionHandler(this.completionHandler, this.exchange));
        }
    }
}

