/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.blocking;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.blocking.BlockingHttpHandler;
import io.undertow.server.handlers.blocking.BlockingHttpServerExchange;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class BlockingHandler
implements HttpHandler {
    private volatile Executor executor;
    private volatile BlockingHttpHandler handler;
    private static final AtomicReferenceFieldUpdater<BlockingHandler, Executor> executorUpdater = AtomicReferenceFieldUpdater.newUpdater(BlockingHandler.class, Executor.class, "executor");
    private static final AtomicReferenceFieldUpdater<BlockingHandler, BlockingHttpHandler> handlerUpdater = AtomicReferenceFieldUpdater.newUpdater(BlockingHandler.class, BlockingHttpHandler.class, "handler");

    public BlockingHandler(Executor executor, BlockingHttpHandler handler) {
        this.executor = executor;
        this.handler = handler;
    }

    public BlockingHandler(BlockingHttpHandler handler) {
        this(null, handler);
    }

    public BlockingHandler() {
        this(null, null);
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange, final HttpCompletionHandler completionHandler) {
        final BlockingHttpServerExchange blockingExchange = new BlockingHttpServerExchange(exchange);
        Executor executor = this.executor;
        (executor == null ? exchange.getConnection().getWorker() : executor).execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BlockingHttpHandler handler = BlockingHandler.this.handler;
                    if (handler != null) {
                        handler.handleRequest(blockingExchange);
                    }
                }
                catch (Throwable t) {
                    if (!exchange.isResponseStarted()) {
                        exchange.setResponseCode(500);
                    }
                    UndertowLogger.REQUEST_LOGGER.errorf(t, "Blocking request failed %s", blockingExchange);
                }
                finally {
                    completionHandler.handleComplete();
                }
            }
        });
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Executor setExecutor(Executor executor) {
        return executorUpdater.getAndSet(this, executor);
    }

    public BlockingHttpHandler getHandler() {
        return this.handler;
    }

    public BlockingHttpHandler setRootHandler(BlockingHttpHandler rootHandler) {
        return handlerUpdater.getAndSet(this, rootHandler);
    }
}

