/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Pooled;

public class DirectBufferCache {
    private static final Pooled<ByteBuffer>[] EMPTY_BUFFERS = new Pooled[0];
    private final ByteBufferSlicePool pool;
    private final AtomicInteger use = new AtomicInteger();
    private final int max;
    private final int sliceSize;
    private final int segmentShift;
    private final Segment[] segments;

    public DirectBufferCache(int sliceSize, int max) {
        this(sliceSize, max, Runtime.getRuntime().availableProcessors());
    }

    public DirectBufferCache(int sliceSize, int max, int concurrency) {
        this.sliceSize = sliceSize;
        this.max = max;
        this.pool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, sliceSize, max);
        int shift = 1;
        while (concurrency > (shift <<= 1)) {
        }
        this.segmentShift = 32 - shift;
        this.segments = new Segment[shift];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(shift);
        }
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    public CacheEntry add(String path, int size) {
        Segment[] segments = this.segments;
        return segments[DirectBufferCache.hash(path.hashCode()) >>> this.segmentShift & segments.length - 1].add(path, size);
    }

    public CacheEntry get(String path) {
        Segment[] segments = this.segments;
        return segments[DirectBufferCache.hash(path.hashCode()) >>> this.segmentShift & segments.length - 1].get(path);
    }

    public void remove(String path) {
        Segment[] segments = this.segments;
        segments[DirectBufferCache.hash(path.hashCode()) >>> this.segmentShift & segments.length - 1].remove(path);
    }

    private class Segment {
        private final LinkedHashMap<String, CacheEntry> cache;
        private final LinkedHashMap<String, Integer> candidates;

        private Segment(int concurrency) {
            int limit = Math.max(100, DirectBufferCache.this.max / DirectBufferCache.this.sliceSize / concurrency);
            this.cache = new CacheMap(limit);
            this.candidates = new MaxLinkedMap<String, Integer>(limit);
        }

        public synchronized CacheEntry get(String path) {
            return this.cache.get(path);
        }

        public synchronized CacheEntry add(String path, int size) {
            int count;
            CacheEntry entry = this.cache.get(path);
            if (entry != null) {
                return null;
            }
            Integer i = this.candidates.get(path);
            int n = count = i == null ? 0 : i;
            if (count > 5) {
                this.candidates.remove(path);
                entry = this.addCacheEntry(path, size);
            } else {
                this.candidates.put(path, ++count);
            }
            return entry;
        }

        private boolean reserveSpace(int size) {
            boolean reserved = false;
            while (!reserved) {
                int inUse = DirectBufferCache.this.use.get();
                if (inUse + size > DirectBufferCache.this.max) {
                    return false;
                }
                reserved = DirectBufferCache.this.use.compareAndSet(inUse, inUse + size);
            }
            return true;
        }

        private CacheEntry addCacheEntry(String path, int size) {
            int reserveSize;
            for (reserveSize = DirectBufferCache.this.sliceSize; reserveSize < size; reserveSize += DirectBufferCache.this.sliceSize) {
            }
            Iterator<CacheEntry> iterator = this.cache.values().iterator();
            boolean reserved = this.reserveSpace(reserveSize);
            while (!reserved && iterator.hasNext()) {
                CacheEntry value = iterator.next();
                iterator.remove();
                value.destroy();
                reserved = this.reserveSpace(reserveSize);
            }
            if (!reserved) {
                return null;
            }
            int num = reserveSize / DirectBufferCache.this.sliceSize;
            Pooled[] buffers = new Pooled[num];
            for (int i = 0; i < num; ++i) {
                buffers[i] = DirectBufferCache.this.pool.allocate();
            }
            CacheEntry result = new CacheEntry(size, buffers);
            this.cache.put(path, result);
            return result;
        }

        public void remove(String path) {
            CacheEntry remove = (CacheEntry)this.cache.remove(path);
            if (remove != null) {
                remove.destroy();
            }
        }
    }

    public class CacheEntry {
        private final int size;
        private volatile Pooled<ByteBuffer>[] buffers;
        private volatile boolean enabled;
        private volatile long time;

        public CacheEntry(int size, Pooled<ByteBuffer>[] buffers) {
            this.size = size;
            this.buffers = buffers;
        }

        public int size() {
            return this.size;
        }

        public Pooled<ByteBuffer>[] buffers() {
            return this.buffers;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public long time() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }

        public void enable() {
            this.enabled = true;
        }

        public void destroy() {
            this.enabled = false;
            for (Pooled<ByteBuffer> buffer : this.buffers()) {
                buffer.free();
                DirectBufferCache.this.use.getAndAdd(-DirectBufferCache.this.sliceSize);
            }
            this.buffers = EMPTY_BUFFERS;
        }
    }

    private static class CacheMap
    extends MaxLinkedMap<String, CacheEntry> {
        private CacheMap(int max) {
            super(max);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
            if (super.removeEldestEntry(eldest)) {
                CacheEntry value = eldest.getValue();
                value.destroy();
                return true;
            }
            return false;
        }
    }

    private static class MaxLinkedMap<K, V>
    extends LinkedHashMap<K, V> {
        private int max;

        public MaxLinkedMap(int max) {
            super(3, 0.66f, false);
            this.max = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.max;
        }
    }
}

