/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.file.FileCache;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.channels.ChannelFactory;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.SuspendableReadChannel;
import org.xnio.channels.SuspendableWriteChannel;

public class DirectFileCache
implements FileCache {
    private static final Logger log = Logger.getLogger((String)"io.undertow.server.handlers.file");
    public static final FileCache INSTANCE = new DirectFileCache();

    @Override
    public void serveFile(HttpServerExchange exchange, HttpCompletionHandler completionHandler, File file) {
        IoUtils.safeShutdownReads((SuspendableReadChannel)exchange.getRequestChannel());
        exchange.getConnection().getWorker().execute((Runnable)new FileWriteTask(exchange, completionHandler, file));
    }

    private static class FileWriteTask
    implements Runnable {
        private final HttpServerExchange exchange;
        private final HttpCompletionHandler completionHandler;
        private final File file;

        private FileWriteTask(HttpServerExchange exchange, HttpCompletionHandler completionHandler, File file) {
            this.exchange = exchange;
            this.completionHandler = completionHandler;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long length;
            FileChannel fileChannel;
            String method = this.exchange.getRequestMethod();
            try {
                try {
                    fileChannel = this.exchange.getConnection().getWorker().getXnio().openFile(this.file, FileAccess.READ_ONLY);
                }
                catch (FileNotFoundException e) {
                    this.exchange.setResponseCode(404);
                    this.completionHandler.handleComplete();
                    return;
                }
                length = fileChannel.size();
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_LOGGER.exceptionReadingFile(this.file, e);
                this.exchange.setResponseCode(500);
                this.completionHandler.handleComplete();
                return;
            }
            this.exchange.getResponseHeaders().put("Content-Length", Long.toString(length));
            if (method.equalsIgnoreCase("HEAD")) {
                this.completionHandler.handleComplete();
                return;
            }
            if (!method.equalsIgnoreCase("GET")) {
                this.exchange.setResponseCode(500);
                this.completionHandler.handleComplete();
                return;
            }
            ChannelFactory<StreamSinkChannel> factory = this.exchange.getResponseChannelFactory();
            if (factory == null) {
                IoUtils.safeClose((Closeable)fileChannel);
                this.completionHandler.handleComplete();
                return;
            }
            StreamSinkChannel response = (StreamSinkChannel)factory.create();
            response.getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

                public void handleEvent(Channel channel) {
                    IoUtils.safeClose((Closeable)fileChannel);
                }
            });
            try {
                log.tracef("Serving file %s (blocking)", (Object)fileChannel);
                Channels.transferBlocking((StreamSinkChannel)response, (FileChannel)fileChannel, (long)0L, (long)length);
                log.tracef("Finished serving %s, shutting down (blocking)", (Object)fileChannel);
                response.shutdownWrites();
                log.tracef("Finished serving %s, flushing (blocking)", (Object)fileChannel);
                Channels.flushBlocking((SuspendableWriteChannel)response);
                log.tracef("Finished serving %s (complete)", (Object)fileChannel);
                this.completionHandler.handleComplete();
            }
            catch (IOException ignored) {
                log.tracef("Failed to serve %s: %s", (Object)fileChannel, (Object)ignored);
                IoUtils.safeClose((Closeable)fileChannel);
                this.completionHandler.handleComplete();
            }
            finally {
                IoUtils.safeClose((Closeable)fileChannel);
                IoUtils.safeClose((Closeable)response);
            }
        }
    }
}

