/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.file;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.file.CachingFileCache;
import io.undertow.server.handlers.file.FileCache;
import java.io.File;

public class FileHandler
implements HttpHandler {
    private volatile File base;
    private volatile FileCache fileCache = new CachingFileCache(1024, 10480);

    public FileHandler(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull();
        }
        this.base = base;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        String path = exchange.getRelativePath();
        if (File.separatorChar != '/') {
            if (path.indexOf(File.separatorChar) != -1) {
                exchange.setResponseCode(404);
                completionHandler.handleComplete();
                return;
            }
            path = path.replace('/', File.separatorChar);
        }
        this.fileCache.serveFile(exchange, completionHandler, new File(this.base, path));
    }

    public File getBase() {
        return this.base;
    }

    public void setBase(File base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull();
        }
        this.base = base;
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    public void setFileCache(FileCache fileCache) {
        if (fileCache == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull();
        }
        this.fileCache = fileCache;
    }
}

