/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.util.SecureHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;

public final class FormData
implements Iterable<String> {
    private final Map<String, FormValue> values = new SecureHashMap<String, FormValue>();

    @Override
    public Iterator<String> iterator() {
        final Iterator<FormValue> iterator = this.values.values().iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return ((FormValue)iterator.next()).getName();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public String getFirst(String name) {
        Deque deque = this.values.get(name);
        return deque == null ? null : (String)deque.peekFirst();
    }

    public String getLast(String name) {
        Deque deque = this.values.get(name);
        return deque == null ? null : (String)deque.peekLast();
    }

    public Deque<String> get(String name) {
        return this.values.get(name);
    }

    public void add(String name, String value) {
        FormValue values = this.values.get(name);
        if (values == null) {
            this.values.put(name, new FormValue(name, value));
        } else {
            values.add(value);
        }
    }

    public void addAll(String name, Collection<String> formValues) {
        FormValue value = this.values.get(name);
        if (value == null) {
            this.values.put(name, new FormValue(name, formValues));
        } else {
            value.addAll(formValues);
        }
    }

    public void addAll(FormData other) {
        for (Map.Entry<String, FormValue> entry : other.values.entrySet()) {
            String key = entry.getKey();
            FormValue value = entry.getValue();
            FormValue target = this.values.get(key);
            if (target == null) {
                this.values.put(key, new FormValue(value.getName(), value));
                continue;
            }
            target.addAll(value);
        }
    }

    public void put(String name, String formValue) {
        FormValue value = new FormValue(name, formValue);
        this.values.put(name, value);
    }

    public void putAll(String name, Collection<String> formValue) {
        FormValue deque = new FormValue(name, formValue);
        this.values.put(name, deque);
    }

    public Collection<String> remove(String name) {
        return this.values.remove(name);
    }

    public boolean contains(String name) {
        FormValue value = this.values.get(name);
        return value != null && !value.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormData strings = (FormData)o;
        return !(this.values != null ? !((Object)this.values).equals(strings.values) : strings.values != null);
    }

    public int hashCode() {
        return this.values != null ? ((Object)this.values).hashCode() : 0;
    }

    public String toString() {
        return "FormData{values=" + this.values + '}';
    }

    static class FormValue
    extends ArrayDeque<String> {
        private final String name;

        FormValue(String name) {
            super(1);
            this.name = name;
        }

        FormValue(String name, String singleValue) {
            this(name);
            this.add(singleValue);
        }

        FormValue(String name, Collection<String> c) {
            super(c);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FormValue strings = (FormValue)o;
            if (this.name != null ? !this.name.equals(strings.name) : strings.name != null) {
                return false;
            }
            if (strings.size() != this.size()) {
                return false;
            }
            Iterator i1 = this.iterator();
            Iterator i2 = strings.iterator();
            while (i1.hasNext()) {
                String n2;
                String n1 = (String)i1.next();
                if (n1.equals(n2 = (String)i2.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

