/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import org.xnio.AbstractIoFuture;
import org.xnio.ChannelListener;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public class FormEncodedDataHandler
implements HttpHandler {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    @Override
    public void handleRequest(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
        String mimeType = exchange.getRequestHeaders().getFirst("Content-Type");
        if (mimeType != null && mimeType.equals(APPLICATION_X_WWW_FORM_URLENCODED)) {
            exchange.putAttachment(FormDataParser.ATTACHMENT_KEY, new AsyncFormEncodedDataParser(exchange, completionHandler));
        }
        HttpHandlers.executeHandler(this.next, exchange, completionHandler);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public void setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
    }

    private static class FormIoFuture
    extends AbstractIoFuture<FormData> {
        private FormIoFuture() {
        }

        public boolean setResult(FormData result) {
            return super.setResult((Object)result);
        }

        public boolean setException(IOException exception) {
            return super.setException(exception);
        }
    }

    private static final class AsyncFormEncodedDataParser
    implements ChannelListener<StreamSourceChannel>,
    FormDataParser {
        private final HttpServerExchange exchange;
        private final HttpCompletionHandler completionHandler;
        private final FormData data = new FormData();
        private final StringBuilder builder = new StringBuilder();
        private String name = null;
        private volatile FormIoFuture ioFuture;
        private int state = 0;

        private AsyncFormEncodedDataParser(HttpServerExchange exchange, HttpCompletionHandler completionHandler) {
            this.exchange = exchange;
            this.completionHandler = completionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(StreamSourceChannel channel) {
            int c = 0;
            Pooled pooled = this.exchange.getConnection().getBufferPool().allocate();
            try {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                do {
                    if ((c = channel.read(buffer)) <= 0) continue;
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        byte n = buffer.get();
                        switch (this.state) {
                            case 0: {
                                if (n == 61) {
                                    this.name = this.builder.toString();
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                if (n == 37 || n == 43) {
                                    this.state = 1;
                                    this.builder.append((char)n);
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 1: {
                                if (n == 61) {
                                    this.name = URLDecoder.decode(this.builder.toString(), "UTF-8");
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 2: {
                                if (n == 38) {
                                    this.data.add(this.name, this.builder.toString());
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                if (n == 37 || n == 43) {
                                    this.state = 3;
                                    this.builder.append((char)n);
                                    break;
                                }
                                this.builder.append((char)n);
                                break;
                            }
                            case 3: {
                                if (n == 38) {
                                    this.data.add(this.name, URLDecoder.decode(this.builder.toString(), "UTF-8"));
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                this.builder.append((char)n);
                            }
                        }
                    }
                } while (c > 0);
                if (c == -1) {
                    if (this.state == 2) {
                        this.data.add(this.name, this.builder.toString());
                    } else if (this.state == 3) {
                        this.data.add(this.name, URLDecoder.decode(this.builder.toString(), "UTF-8"));
                    }
                    this.state = 4;
                    this.ioFuture.setResult(this.data);
                }
            }
            catch (IOException e) {
                this.ioFuture.setException(e);
                IoUtils.safeClose((Closeable)channel);
                UndertowLogger.REQUEST_LOGGER.ioExceptionReadingFromChannel(e);
                this.completionHandler.handleComplete();
            }
            finally {
                pooled.free();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IoFuture<FormData> parse() {
            if (this.ioFuture == null) {
                FormIoFuture created = null;
                AsyncFormEncodedDataParser asyncFormEncodedDataParser = this;
                synchronized (asyncFormEncodedDataParser) {
                    if (this.ioFuture == null) {
                        this.ioFuture = created = new FormIoFuture();
                    }
                }
                if (created != null) {
                    StreamSourceChannel channel = this.exchange.getRequestChannel();
                    if (channel == null) {
                        created.setException(new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided()));
                    } else {
                        this.handleEvent(channel);
                        if (this.state != 4) {
                            channel.getReadSetter().set((ChannelListener)this);
                            channel.resumeReads();
                        }
                    }
                }
            }
            return this.ioFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FormData parseBlocking() throws IOException {
            if (this.ioFuture == null) {
                FormIoFuture created = null;
                AsyncFormEncodedDataParser asyncFormEncodedDataParser = this;
                synchronized (asyncFormEncodedDataParser) {
                    if (this.ioFuture == null) {
                        this.ioFuture = created = new FormIoFuture();
                    }
                }
                if (created != null) {
                    StreamSourceChannel channel = this.exchange.getRequestChannel();
                    if (channel == null) {
                        created.setException(new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided()));
                    } else {
                        while (this.state != 4) {
                            this.handleEvent(channel);
                            if (this.state == 4) continue;
                            channel.awaitReadable();
                        }
                    }
                }
            }
            return (FormData)this.ioFuture.get();
        }
    }
}

