/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.httpparser;

import io.undertow.server.httpparser.HttpExchangeBuilder;
import io.undertow.server.httpparser.ParseState;
import java.nio.ByteBuffer;

public abstract class HttpParser {
    public static final HttpParser INSTANCE;
    private static final int START = 0;
    private static final int FIRST_COLON = 1;
    private static final int FIRST_SLASH = 2;
    private static final int SECOND_SLASH = 3;
    private static final int HOST_DONE = 4;
    private static final int QUERY_PARAM_NAME = 5;
    private static final int QUERY_PARAM_VALUE = 6;
    private static final int NORMAL = 0;
    private static final int WHITESPACE = 1;
    private static final int BEGIN_LINE_END = 2;
    private static final int LINE_END = 3;
    private static final int AWAIT_DATA_END = 4;

    public abstract int handle(ByteBuffer var1, int var2, ParseState var3, HttpExchangeBuilder var4);

    final int handlePath(ByteBuffer buffer, int remaining, ParseState state, HttpExchangeBuilder builder) {
        StringBuilder stringBuilder = state.stringBuilder;
        int parseState = state.parseState;
        int canonicalPathStart = state.pos;
        int queryParamPos = state.queryParamPos;
        String nextQueryParam = state.nextHeader;
        if (stringBuilder == null) {
            state.stringBuilder = stringBuilder = new StringBuilder();
        }
        while (remaining > 0) {
            char next = (char)buffer.get();
            --remaining;
            if (next == ' ' || next == '\t') {
                String path;
                if (stringBuilder.length() == 0) continue;
                builder.fullPath = path = stringBuilder.toString();
                builder.relativePath = parseState < 4 ? path : path.substring(canonicalPathStart);
                if (parseState == 5) {
                    builder.addQueryParam(stringBuilder.substring(queryParamPos), "");
                } else if (parseState == 6) {
                    builder.addQueryParam(nextQueryParam, stringBuilder.substring(queryParamPos));
                }
                state.state = 2;
                state.stringBuilder = null;
                state.parseState = 0;
                state.pos = 0;
                state.nextHeader = null;
                state.queryParamPos = 0;
                return remaining;
            }
            if (next == ':' && parseState == 0) {
                parseState = 1;
            } else if (next == '/' && parseState == 1) {
                parseState = 2;
            } else if (next == '/' && parseState == 2) {
                parseState = 3;
            } else if (next == '/' && parseState == 3) {
                parseState = 4;
                canonicalPathStart = stringBuilder.length();
            } else if (parseState == 1 || parseState == 2) {
                parseState = 0;
            } else if (next == '?' && (parseState == 0 || parseState == 4)) {
                parseState = 5;
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '=' && parseState == 5) {
                parseState = 6;
                nextQueryParam = stringBuilder.substring(queryParamPos);
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '&' && parseState == 5) {
                parseState = 5;
                builder.addQueryParam(stringBuilder.substring(queryParamPos), "");
                nextQueryParam = null;
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '&' && parseState == 6) {
                parseState = 5;
                builder.addQueryParam(nextQueryParam, stringBuilder.substring(queryParamPos));
                nextQueryParam = null;
                queryParamPos = stringBuilder.length() + 1;
            }
            stringBuilder.append(next);
        }
        state.stringBuilder = stringBuilder;
        state.parseState = parseState;
        state.pos = canonicalPathStart;
        state.nextHeader = nextQueryParam;
        state.queryParamPos = queryParamPos;
        return remaining;
    }

    final int handleHeaderValue(ByteBuffer buffer, int remaining, ParseState state, HttpExchangeBuilder builder) {
        StringBuilder stringBuilder = state.stringBuilder;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
            state.parseState = 0;
        }
        int parseState = state.parseState;
        while (remaining > 0) {
            byte next = buffer.get();
            --remaining;
            switch (parseState) {
                case 0: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) {
                        parseState = 1;
                        break;
                    }
                    stringBuilder.append((char)next);
                    break;
                }
                case 1: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) break;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append((char)next);
                    parseState = 0;
                    break;
                }
                case 2: 
                case 3: {
                    if (next == 10 && parseState == 2) {
                        parseState = 3;
                        break;
                    }
                    if (next == 9 || next == 32) {
                        parseState = 1;
                        break;
                    }
                    String nextStandardHeader = state.nextHeader;
                    String headerValue = stringBuilder.toString();
                    builder.headers.put(nextStandardHeader, headerValue);
                    state.nextHeader = null;
                    state.leftOver = next;
                    state.stringBuilder = null;
                    if (next == 13) {
                        parseState = 4;
                        break;
                    }
                    state.state = 4;
                    state.parseState = 0;
                    return remaining;
                }
                case 4: {
                    state.state = 6;
                    return remaining;
                }
            }
        }
        state.parseState = parseState;
        state.stringBuilder = stringBuilder;
        return remaining;
    }

    protected int handleAfterVersion(ByteBuffer buffer, int remaining, ParseState state, HttpExchangeBuilder builder) {
        boolean newLine;
        boolean bl = newLine = state.leftOver == 10;
        while (remaining > 0) {
            byte next = buffer.get();
            --remaining;
            if (newLine) {
                if (next == 10) {
                    state.state = 6;
                    return remaining;
                }
                state.state = 4;
                state.leftOver = next;
                return remaining;
            }
            if (next == 10) {
                newLine = true;
                continue;
            }
            if (next == 13 || next == 32 || next == 9) continue;
            state.state = 4;
            state.leftOver = next;
            return remaining;
        }
        if (newLine) {
            state.leftOver = (byte)10;
        }
        return remaining;
    }

    static {
        try {
            Class<?> cls = HttpParser.class.getClassLoader().loadClass(HttpParser.class.getName() + "$$generated");
            INSTANCE = (HttpParser)cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

