/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SecureRandomeSessionIdGenerator;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.util.SecureHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.xnio.FinishedIoFuture;
import org.xnio.IoFuture;

public class InMemorySessionManager
implements SessionManager {
    private volatile SessionIdGenerator sessionIdGenerator = new SecureRandomeSessionIdGenerator();
    private final ConcurrentMap<String, InMemorySession> sessions = new SecureHashMap<String, InMemorySession>();
    private volatile List<SessionListener> listeners = Collections.emptyList();
    private volatile int defaultSessionTimeout = 1800;

    @Override
    public IoFuture<Session> createSession(HttpServerExchange serverExchange) {
        String sessionID = this.sessionIdGenerator.createSessionId();
        SessionImpl session = new SessionImpl(sessionID);
        InMemorySession im = new InMemorySession(session, this.defaultSessionTimeout);
        this.sessions.put(sessionID, im);
        for (SessionListener listener : this.listeners) {
            listener.sessionCreated(session, serverExchange);
        }
        SessionCookieConfig config = (SessionCookieConfig)serverExchange.getAttachment("io.undertow.session.SessionCookie");
        if (config != null) {
            config.setSessionCookie(serverExchange, session);
        } else {
            UndertowLogger.REQUEST_LOGGER.couldNotFindSessionCookieConfig();
        }
        return new FinishedIoFuture((Object)session);
    }

    @Override
    public IoFuture<Session> getSession(HttpServerExchange serverExchange, String sessionId) {
        InMemorySession sess = (InMemorySession)this.sessions.get(sessionId);
        if (sess == null) {
            return new FinishedIoFuture(null);
        }
        sess.lastAccessed = System.currentTimeMillis();
        return new FinishedIoFuture((Object)sess.session);
    }

    @Override
    public synchronized void registerSessionListener(SessionListener listener) {
        ArrayList<SessionListener> listeners = new ArrayList<SessionListener>(this.listeners);
        listeners.add(listener);
        this.listeners = Collections.unmodifiableList(listeners);
    }

    @Override
    public synchronized void removeSessionListener(SessionListener listener) {
        ArrayList<SessionListener> listeners = new ArrayList<SessionListener>(this.listeners);
        listeners.remove(listener);
        this.listeners = Collections.unmodifiableList(listeners);
    }

    @Override
    public void setDefaultSessionTimeout(int timeout) {
        this.defaultSessionTimeout = timeout;
    }

    private static class InMemorySession {
        private final Session session;
        private final ConcurrentMap<String, Object> attributes = new SecureHashMap<String, Object>();
        private volatile long lastAccessed;
        private final long creationTime;
        private volatile int maxInactiveInterval;

        InMemorySession(Session session, int maxInactiveInterval) {
            this.session = session;
            this.creationTime = this.lastAccessed = System.currentTimeMillis();
            this.maxInactiveInterval = maxInactiveInterval;
        }
    }

    private class SessionImpl
    implements Session {
        private final String sessionId;

        private SessionImpl(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public String getId() {
            return this.sessionId;
        }

        @Override
        public void requestDone(HttpServerExchange serverExchange) {
        }

        @Override
        public long getCreationTime() {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.creationTime;
        }

        @Override
        public long getLastAccessedTime() {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.lastAccessed;
        }

        @Override
        public void setMaxInactiveInterval(int interval) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            sess.maxInactiveInterval = interval;
        }

        @Override
        public int getMaxInactiveInterval() {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return sess.maxInactiveInterval;
        }

        @Override
        public IoFuture<Object> getAttribute(String name) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return new FinishedIoFuture(sess.attributes.get(name));
        }

        @Override
        public IoFuture<Set<String>> getAttributeNames() {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            return new FinishedIoFuture(sess.attributes.keySet());
        }

        @Override
        public IoFuture<Void> setAttribute(String name, Object value) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            Object existing = sess.attributes.put(name, value);
            for (SessionListener listener : InMemorySessionManager.this.listeners) {
                if (existing == null) {
                    listener.attributeAdded(sess.session, name, value);
                    continue;
                }
                listener.attributeUpdated(sess.session, name, value);
            }
            return new FinishedIoFuture(null);
        }

        @Override
        public IoFuture<Void> removeAttribute(String name) {
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.get(this.sessionId);
            if (sess == null) {
                throw UndertowMessages.MESSAGES.sessionNotFound(this.sessionId);
            }
            Object existing = sess.attributes.remove(name);
            for (SessionListener listener : InMemorySessionManager.this.listeners) {
                listener.attributeRemoved(sess.session, name);
            }
            return new FinishedIoFuture(null);
        }

        @Override
        public IoFuture<Void> invalidate(HttpServerExchange exchange) {
            SessionCookieConfig config;
            InMemorySession sess = (InMemorySession)InMemorySessionManager.this.sessions.remove(this.sessionId);
            if (sess != null) {
                for (SessionListener listener : InMemorySessionManager.this.listeners) {
                    listener.sessionDestroyed(sess.session, exchange, false);
                }
            }
            if ((config = (SessionCookieConfig)exchange.getAttachment("io.undertow.session.SessionCookie")) != null) {
                config.clearCookie(exchange, this);
            } else {
                UndertowLogger.REQUEST_LOGGER.couldNotFindSessionCookieConfig();
            }
            return new FinishedIoFuture(null);
        }

        @Override
        public SessionManager getSessionManager() {
            return InMemorySessionManager.this;
        }
    }
}

