/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.server.HttpCompletionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.HttpHandlers;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import java.io.IOException;
import java.util.Map;
import org.xnio.IoFuture;

public class SessionAttachmentHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private volatile SessionManager sessionManager;
    private volatile String path;
    private volatile String domain;
    private volatile boolean discardOnExit = false;
    private volatile boolean secure = false;
    private volatile String cookieName = "JSESSIONID";

    public SessionAttachmentHandler(SessionManager sessionManager) {
        if (sessionManager == null) {
            throw UndertowMessages.MESSAGES.sessionManagerMustNotBeNull();
        }
        this.sessionManager = sessionManager;
    }

    @Override
    public void handleRequest(final HttpServerExchange exchange, final HttpCompletionHandler completionHandler) {
        if (this.sessionManager == null) {
            throw UndertowMessages.MESSAGES.sessionManagerMustNotBeNull();
        }
        exchange.putAttachment(SessionManager.ATTACHMENT_KEY, this.sessionManager);
        String path = this.path;
        if (path == null) {
            path = exchange.getResolvedPath();
        }
        exchange.putAttachment("io.undertow.session.SessionCookie", new SessionCookieConfig(this.cookieName, path, this.domain, this.discardOnExit, this.secure));
        String sessionId = this.findSessionId(exchange);
        if (sessionId == null) {
            HttpHandlers.executeHandler(this.next, exchange, completionHandler);
        } else {
            IoFuture<Session> session = this.sessionManager.getSession(exchange, sessionId);
            session.addNotifier((IoFuture.Notifier)new IoFuture.Notifier<Session, Session>(){

                public void notify(IoFuture<? extends Session> ioFuture, Session attachment) {
                    try {
                        if (ioFuture.getStatus() == IoFuture.Status.DONE) {
                            exchange.putAttachment("io.undertow.session.Session", ioFuture.get());
                            HttpHandlers.executeHandler(SessionAttachmentHandler.this.next, exchange, completionHandler);
                        } else if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                            UndertowLogger.REQUEST_LOGGER.getSessionFailed(ioFuture.getException());
                            HttpHandlers.executeHandler(ResponseCodeHandler.HANDLE_500, exchange, completionHandler);
                        } else {
                            UndertowLogger.REQUEST_LOGGER.unexpectedStatusGettingSession(ioFuture.getStatus());
                            HttpHandlers.executeHandler(ResponseCodeHandler.HANDLE_500, exchange, completionHandler);
                        }
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_LOGGER.getSessionFailed(e);
                        HttpHandlers.executeHandler(ResponseCodeHandler.HANDLE_500, exchange, completionHandler);
                    }
                }
            }, null);
        }
    }

    private String findSessionId(HttpServerExchange exchange) {
        Cookie sessionId;
        Map<String, Cookie> cookies = Cookie.getRequestCookies(exchange);
        if (cookies != null && (sessionId = cookies.get(this.cookieName)) != null) {
            return sessionId.getValue();
        }
        return null;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public void setNext(HttpHandler next) {
        HttpHandlers.handlerNotNull(next);
        this.next = next;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (sessionManager == null) {
            throw UndertowMessages.MESSAGES.sessionManagerMustNotBeNull();
        }
        this.sessionManager = sessionManager;
    }

    public String getPath() {
        return this.path;
    }

    public synchronized void setPath(String path) {
        this.path = path;
    }

    public String getDomain() {
        return this.domain;
    }

    public synchronized void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isDiscardOnExit() {
        return this.discardOnExit;
    }

    public synchronized void setDiscardOnExit(boolean discardOnExit) {
        this.discardOnExit = discardOnExit;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public synchronized void setSecure(boolean secure) {
        this.secure = secure;
    }
}

