/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.util.Attachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.ListAttachmentKey;
import io.undertow.util.SecureHashMap;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractAttachable
implements Attachable {
    private final ConcurrentMap<Object, Object> attachments = new SecureHashMap<Object, Object>();

    @Override
    public Object getAttachment(String name) {
        return this.attachments.get(name);
    }

    @Override
    public Object putAttachment(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return this.attachments.put(name, value);
    }

    @Override
    public Object putAttachmentIfAbsent(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return this.attachments.putIfAbsent(name, value);
    }

    @Override
    public Object replaceAttachment(String name, Object newValue) {
        return this.attachments.replace(name, newValue);
    }

    @Override
    public Object removeAttachment(String name) {
        return this.attachments.remove(name);
    }

    @Override
    public boolean replaceAttachment(String name, Object expectValue, Object newValue) {
        return this.attachments.replace(name, expectValue, newValue);
    }

    @Override
    public boolean removeAttachment(String name, Object expectValue) {
        return this.attachments.remove(name, expectValue);
    }

    @Override
    public <T> T getAttachment(AttachmentKey<T> key) {
        if (key == null) {
            return null;
        }
        return key.cast(this.attachments.get(key));
    }

    @Override
    public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        if (key == null) {
            return null;
        }
        List<T> list = key.cast(this.attachments.get(key));
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull();
        }
        return key.cast(this.attachments.put(key, key.cast(value)));
    }

    @Override
    public <T> T putAttachmentIfAbsent(AttachmentKey<T> key, T value) {
        if (key == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull();
        }
        return key.cast(this.attachments.putIfAbsent(key, key.cast(value)));
    }

    @Override
    public <T> T removeAttachment(AttachmentKey<T> key) {
        if (key == null) {
            return null;
        }
        return key.cast(this.attachments.remove(key));
    }

    @Override
    public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        if (key != null) {
            ConcurrentMap<Object, Object> attachments = this.attachments;
            AttachmentList<T> list = key.cast(attachments.get(key));
            if (list == null) {
                AttachmentList<T> newList = new AttachmentList<T>(((ListAttachmentKey)key).getValueClass());
                attachments.put(key, newList);
                newList.add(value);
            } else {
                list.add(value);
            }
        }
    }
}

