/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.jboss.logging.Logger;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class ChunkedStreamSinkChannel
implements StreamSinkChannel {
    private static final Logger log = Logger.getLogger(ChunkedStreamSinkChannel.class);
    private final StreamSinkChannel delegate;
    private final ChannelListener.SimpleSetter<ChunkedStreamSinkChannel> closeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<ChunkedStreamSinkChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener<? super ChunkedStreamSinkChannel> finishListener;
    private final int config;
    private final Pool<ByteBuffer> bufferPool;
    private volatile Pooled<ByteBuffer> pooledBuffer = null;
    private static final byte[] LAST_CHUNK = "0\r\n\r\n".getBytes();
    public static final byte[] CRLF = "\r\n".getBytes();
    private volatile int state;
    private volatile Thread waiter;
    private volatile Thread lockWaiter;
    private static final AtomicIntegerFieldUpdater<ChunkedStreamSinkChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ChunkedStreamSinkChannel.class, "state");
    private static final AtomicReferenceFieldUpdater<ChunkedStreamSinkChannel, Thread> waiterUpdater = AtomicReferenceFieldUpdater.newUpdater(ChunkedStreamSinkChannel.class, Thread.class, "waiter");
    private static final AtomicReferenceFieldUpdater<ChunkedStreamSinkChannel, Thread> lockWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(ChunkedStreamSinkChannel.class, Thread.class, "lockWaiter");
    private static final int CHUNKING_OVERHEAD_MAX_BYTES = 14;
    private static final int CONF_FLAG_CONFIGURABLE = 1;
    private static final int CONF_FLAG_PASS_CLOSE = 2;
    private static final int FLAG_IN_WRITE = 1;
    private static final int FLAG_IN = 2;
    private static final int FLAG_CLOSE_REQ = 4;
    private static final int FLAG_CLOSE_SENT = 8;
    private static final int FLAG_CLOSE_DONE = 16;
    private static final int FLAG_RESUME = 32;
    private static final int FLAG_WRITING_CHUNKED = 64;
    private static final int FLAG_CLOSING_ASYNC = 128;
    private static final int FLAG_FINISH = 256;

    public ChunkedStreamSinkChannel(StreamSinkChannel delegate, boolean configurable, boolean passClose, ChannelListener<? super ChunkedStreamSinkChannel> finishListener, Pool<ByteBuffer> bufferPool) {
        this.delegate = delegate;
        this.finishListener = finishListener;
        this.bufferPool = bufferPool;
        this.config = (configurable ? 1 : 0) | (passClose ? 2 : 0);
        delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.writeSetter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enter(int setFlags, int clearFlags, int skipIfSet, int skipIfClear) {
        boolean writeIntended = Bits.allAreSet((int)setFlags, (int)1);
        Thread currentThread = Thread.currentThread();
        boolean intr = false;
        try {
            int newVal;
            int oldVal;
            do {
                oldVal = this.state;
                if (writeIntended && Bits.allAreSet((int)oldVal, (int)1)) {
                    throw new ConcurrentStreamChannelAccessException();
                }
                if (Bits.anyAreSet((int)oldVal, (int)skipIfSet) || Bits.anyAreClear((int)oldVal, (int)skipIfClear)) {
                    int n = oldVal;
                    return n;
                }
                while (Bits.anyAreSet((int)oldVal, (int)3)) {
                    Thread waiter = lockWaiterUpdater.getAndSet(this, currentThread);
                    oldVal = this.state;
                    if (Bits.anyAreSet((int)oldVal, (int)3)) {
                        LockSupport.park(this);
                        if (Thread.interrupted()) {
                            intr = true;
                        }
                    }
                    ChunkedStreamSinkChannel.safeUnpark(waiter);
                }
            } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal & ~clearFlags | setFlags));
            int n = oldVal;
            return n;
        }
        finally {
            if (intr) {
                currentThread.interrupt();
            }
        }
    }

    private void exit(int oldVal, int enterFlag, int setFlags) {
        int newVal = oldVal & ~enterFlag | setFlags;
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & ~enterFlag | setFlags;
        }
        if (Bits.allAreClear((int)newVal, (int)192) && this.pooledBuffer != null) {
            this.pooledBuffer.free();
            this.pooledBuffer = null;
        }
        if (Bits.anyAreSet((int)enterFlag, (int)64)) {
            ChunkedStreamSinkChannel.safeUnpark(waiterUpdater.getAndSet(this, null));
        }
        ChunkedStreamSinkChannel.safeUnpark(lockWaiterUpdater.getAndSet(this, null));
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        int val = this.enter(1, 0, 68, 0);
        if (Bits.anyAreSet((int)val, (int)4)) {
            throw new ClosedChannelException();
        }
        int clearFlags = 0;
        int exitFlag = 0;
        if (!this.continueWrite(val)) {
            return 0;
        }
        clearFlags = 64;
        try {
            if (!src.hasRemaining()) {
                int n = 0;
                return n;
            }
            Pooled buffer = this.pooledBuffer = this.bufferPool.allocate();
            ByteBuffer buff = (ByteBuffer)buffer.getResource();
            int maxSize = buff.capacity() - 14;
            int toWrite = Math.min(src.remaining(), maxSize);
            buff.clear();
            buff.put(Integer.toHexString(toWrite).getBytes());
            buff.put(CRLF);
            buff.flip();
            this.writeBuffer(buff);
            if (toWrite != src.remaining()) {
                if (log.isTraceEnabled()) {
                    log.tracef("Copying into our buffer, as src size of %s was bigger than %s", (Object)src.remaining(), (Object)maxSize);
                }
                buff.compact();
                for (int i = 0; i < toWrite; ++i) {
                    buff.put(src.get());
                }
                buff.put(CRLF);
                buff.flip();
                this.writeBuffer(buff);
                if (buff.hasRemaining()) {
                    exitFlag = 64;
                }
            } else {
                if (buff.hasRemaining()) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Copying into our buffer, as initial write of chunk size did not complete", new Object[0]);
                    }
                    buff.compact();
                } else {
                    if (log.isTraceEnabled()) {
                        log.tracef("Attempting to write out source buffer directly", new Object[0]);
                    }
                    this.writeBuffer(src);
                    if (!src.hasRemaining()) {
                        buff.clear();
                        buff.put(CRLF);
                        buff.flip();
                        this.writeBuffer(buff);
                        if (buff.hasRemaining()) {
                            exitFlag = 64;
                        }
                        int n = toWrite;
                        return n;
                    }
                }
                buff.put(src);
                buff.put(CRLF);
                buff.flip();
                exitFlag = 64;
            }
            int n = toWrite;
            return n;
        }
        finally {
            this.exit(val, 1 | clearFlags, exitFlag);
        }
    }

    private void writeBuffer(ByteBuffer buff) throws IOException {
        int c;
        while ((c = this.delegate.write(buff)) != 0 && buff.hasRemaining()) {
        }
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            return this.write(srcs[i]);
        }
        return 0L;
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            throw new ClosedChannelException();
        }
        return src.transferTo(position, count, (WritableByteChannel)((Object)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            throw new ClosedChannelException();
        }
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() throws IOException {
        int val = this.enter(2, 0, 16, 0);
        if (Bits.allAreSet((int)val, (int)16)) {
            return true;
        }
        int setFlags = 0;
        int clearFlags = 0;
        try {
            boolean flushed;
            if (!this.continueWrite(val)) {
                boolean bl = false;
                return bl;
            }
            clearFlags = 192;
            if (Bits.allAreSet((int)this.config, (int)2) && Bits.allAreSet((int)val, (int)4) && Bits.allAreClear((int)val, (int)8)) {
                setFlags |= 8;
                this.delegate.shutdownWrites();
            }
            if ((flushed = this.delegate.flush()) && Bits.anyAreSet((int)val, (int)4) && Bits.anyAreClear((int)val, (int)256)) {
                ChannelListeners.invokeChannelListener((Channel)((Object)this), this.finishListener);
                setFlags |= 0x100;
            }
            if (flushed && Bits.anyAreSet((int)(val | setFlags), (int)8)) {
                this.delegate.suspendWrites();
                this.delegate.getWriteSetter().set(null);
                setFlags |= 0x10;
            }
            boolean bl = flushed;
            return bl;
        }
        finally {
            this.exit(val, 2 | clearFlags, setFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendWrites() {
        int val = this.enter(2, 32, 16, 32);
        if (Bits.anyAreSet((int)val, (int)16)) {
            return;
        }
        if (Bits.allAreClear((int)val, (int)32)) {
            return;
        }
        try {
            this.delegate.suspendWrites();
        }
        finally {
            this.exit(val, 2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWrites() {
        int val = this.enter(34, 0, 48, 0);
        if (Bits.anyAreSet((int)val, (int)48)) {
            return;
        }
        try {
            this.delegate.resumeWrites();
        }
        finally {
            this.exit(val, 2, 0);
        }
    }

    public boolean isWriteResumed() {
        int state = this.state;
        return Bits.allAreSet((int)state, (int)32) && Bits.allAreClear((int)state, (int)16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupWrites() {
        int val = this.enter(34, 0, 48, 0);
        if (Bits.anyAreSet((int)val, (int)48)) {
            return;
        }
        try {
            this.delegate.wakeupWrites();
        }
        finally {
            this.exit(val, 2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownWrites() throws IOException {
        int val = this.enter(6, 0, 4, 0);
        if (Bits.allAreSet((int)val, (int)4)) {
            return;
        }
        int setFlags = 0;
        int clearFlags = 0;
        try {
            setFlags |= 8;
            if (this.continueWrite(val | 0x80)) {
                this.delegate.suspendWrites();
                this.delegate.getWriteSetter().set(null);
                if (Bits.allAreSet((int)this.config, (int)2)) {
                    this.delegate.shutdownWrites();
                }
                clearFlags |= 0x40;
            } else {
                setFlags |= 0x80;
            }
        }
        finally {
            this.exit(val, 2 | clearFlags, setFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int val = this.enter(30, 0, 16, 0);
        int setFlags = 0;
        try {
            if (Bits.allAreSet((int)val, (int)16)) {
                return;
            }
            if (Bits.anyAreSet((int)val, (int)192) || Bits.anyAreClear((int)val, (int)260)) {
                throw UndertowMessages.MESSAGES.closeCalledWithDataStillToBeFlushed();
            }
            this.delegate.suspendWrites();
            this.delegate.getWriteSetter().set(null);
            if (Bits.allAreSet((int)this.config, (int)2)) {
                this.delegate.close();
            }
        }
        finally {
            this.exit(val, 2, setFlags);
            ChannelListeners.invokeChannelListener((Channel)((Object)this), (ChannelListener)this.closeSetter.get());
        }
    }

    public void awaitWritable() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            throw new ClosedChannelException();
        }
        this.delegate.awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            throw new ClosedChannelException();
        }
        this.delegate.awaitWritable(time, timeUnit);
    }

    public boolean isOpen() {
        return Bits.allAreClear((int)this.state, (int)16);
    }

    public boolean supportsOption(Option<?> option) {
        return Bits.allAreSet((int)this.config, (int)1) && this.delegate.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)(Bits.allAreSet((int)this.config, (int)1) ? this.delegate.getOption(option) : null);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)(Bits.allAreSet((int)this.config, (int)1) ? this.delegate.setOption(option, value) : null);
    }

    private static void safeUnpark(Thread waiter) {
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    private boolean continueWrite(int flags) throws IOException {
        Pooled pooledBuffer = this.pooledBuffer;
        if (Bits.allAreClear((int)flags, (int)64) && Bits.anyAreSet((int)flags, (int)128)) {
            ByteBuffer buffer;
            if (pooledBuffer == null) {
                this.pooledBuffer = pooledBuffer = this.bufferPool.allocate();
                buffer = (ByteBuffer)pooledBuffer.getResource();
                buffer.clear();
                buffer.put(LAST_CHUNK);
                buffer.flip();
            }
            buffer = (ByteBuffer)pooledBuffer.getResource();
            this.writeBuffer(buffer);
            return !buffer.hasRemaining();
        }
        if (Bits.anyAreSet((int)flags, (int)64)) {
            int c;
            ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
            do {
                c = this.delegate.write(buffer);
            } while (buffer.hasRemaining() && c > 0);
            if (!buffer.hasRemaining() && Bits.anyAreSet((int)flags, (int)128)) {
                buffer.clear();
                buffer.put(LAST_CHUNK);
                buffer.flip();
                do {
                    c = this.delegate.write(buffer);
                } while (buffer.hasRemaining() && c > 0);
            }
            return !buffer.hasRemaining();
        }
        return true;
    }
}

