/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.XnioExecutor;
import org.xnio.XnioWorker;
import org.xnio.channels.ConcurrentStreamChannelAccessException;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class ChunkedStreamSourceChannel
implements StreamSourceChannel {
    private final PushBackStreamChannel delegate;
    private final boolean configurable;
    private final Pool<ByteBuffer> bufferPool;
    private volatile Pooled<ByteBuffer> rawData;
    private final ChannelListener<? super ChunkedStreamSourceChannel> finishListener;
    private final ChannelListener.SimpleSetter<ChunkedStreamSourceChannel> readSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<ChunkedStreamSourceChannel> closeSetter = new ChannelListener.SimpleSetter();
    private volatile long state;
    private static final long FLAG_READ_ENTERED = Long.MIN_VALUE;
    private static final long FLAG_CLOSED = 0x4000000000000000L;
    private static final long FLAG_SUS_RES_SHUT = 0x2000000000000000L;
    private static final long FLAG_FINISHED = 0x1000000000000000L;
    private static final long FLAG_READING_LENGTH = 0x800000000000000L;
    private static final long FLAG_READING_TILL_END_OF_LINE = 0x400000000000000L;
    private static final long FLAG_READING_NEWLINE = 0x200000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask((int)0, (int)56);
    private static final AtomicLongFieldUpdater<ChunkedStreamSourceChannel> stateUpdater = AtomicLongFieldUpdater.newUpdater(ChunkedStreamSourceChannel.class, "state");

    public ChunkedStreamSourceChannel(PushBackStreamChannel delegate, ChannelListener<? super ChunkedStreamSourceChannel> finishListener, Pool<ByteBuffer> bufferPool) {
        this(delegate, false, bufferPool, finishListener);
    }

    public ChunkedStreamSourceChannel(PushBackStreamChannel delegate, boolean configurable, Pool<ByteBuffer> bufferPool, ChannelListener<? super ChunkedStreamSourceChannel> finishListener) {
        this.bufferPool = bufferPool;
        this.finishListener = finishListener;
        this.delegate = delegate;
        delegate.getReadSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.readSetter));
        this.configurable = configurable;
        stateUpdater.set(this, 0x800000000000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long newVal;
        long oldVal = this.enterRead();
        if (Bits.anyAreSet((long)oldVal, (long)0x1000000000000000L)) {
            return -1L;
        }
        if (Bits.anyAreClear((long)oldVal, (long)0x4000000000000000L)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet((long)oldVal, (long)0x1E00000000000000L)) {
            newVal = this.readRawData(oldVal);
        } else {
            assert ((oldVal & MASK_COUNT) != 0L);
            newVal = oldVal;
        }
        long chunkRemaining = newVal & MASK_COUNT;
        try {
            long pos = position;
            long remaining = count;
            if (Bits.anyAreSet((long)newVal, (long)0x1E00000000000000L)) {
                long l = 0L;
                return l;
            }
            int read = 0;
            Pooled<ByteBuffer> buffer = this.rawData;
            if (buffer != null) {
                ByteBuffer buf = (ByteBuffer)buffer.getResource();
                if ((long)buf.remaining() > count) {
                    long c;
                    int orig = buf.limit();
                    buf.limit((int)((long)buf.position() + count));
                    int written = 0;
                    do {
                        c = target.write(buf, pos);
                        written = (int)((long)written + c);
                        pos += c;
                    } while (buf.hasRemaining() && c > 0L);
                    buf.limit(orig);
                    chunkRemaining -= (long)written;
                    long l = written;
                    return l;
                }
                if (buf.hasRemaining()) {
                    long c;
                    int written = 0;
                    do {
                        c = target.write(buf, pos);
                        written = (int)((long)written + c);
                        pos += c;
                    } while (buf.hasRemaining() && c > 0L);
                    chunkRemaining -= (long)written;
                    if (buf.hasRemaining()) {
                        long l = written;
                        return l;
                    }
                    read += written;
                    remaining -= (long)written;
                }
            }
            if (chunkRemaining > 0L) {
                long c = 0L;
                remaining = Math.min(chunkRemaining, remaining);
                do {
                    if ((c = this.delegate.transferTo(pos, remaining, target)) <= 0L) continue;
                    read = (int)((long)read + c);
                    chunkRemaining -= c;
                    pos += c;
                    remaining -= c;
                } while (c > 0L && remaining > 0L);
                if (c == -1L) {
                    newVal |= 0x1000000000000000L;
                }
                if (chunkRemaining == 0L) {
                    newVal |= 0x200000000000000L;
                }
            }
            long l = read;
            return l;
        }
        finally {
            this.exitRead(chunkRemaining, newVal & 0x1C00000000000000L, (newVal ^ 0xFFFFFFFFFFFFFFFFL) & 0xC00000000000000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long newVal;
        long oldVal = this.enterRead();
        if (Bits.anyAreSet((long)oldVal, (long)0x1000000000000000L)) {
            return -1L;
        }
        if (Bits.anyAreClear((long)oldVal, (long)0x4000000000000000L)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet((long)oldVal, (long)0x1E00000000000000L)) {
            newVal = this.readRawData(oldVal);
        } else {
            assert ((oldVal & MASK_COUNT) != 0L);
            newVal = oldVal;
        }
        long chunkRemaining = newVal & MASK_COUNT;
        try {
            long remaining = count;
            if (Bits.anyAreSet((long)newVal, (long)0x1E00000000000000L)) {
                long l = 0L;
                return l;
            }
            int read = 0;
            Pooled<ByteBuffer> buffer = this.rawData;
            if (buffer != null) {
                ByteBuffer buf = (ByteBuffer)buffer.getResource();
                if ((long)buf.remaining() > count) {
                    int orig = buf.limit();
                    buf.limit((int)((long)buf.position() + count));
                    int written = 0;
                    long c = 0L;
                    do {
                        c = target.write(buf);
                        written = (int)((long)written + c);
                    } while (buf.hasRemaining() && c > 0L);
                    buf.limit(orig);
                    chunkRemaining -= (long)written;
                    long l = written;
                    return l;
                }
                if (buf.hasRemaining()) {
                    int written = 0;
                    long c = 0L;
                    do {
                        c = target.write(buf);
                        written = (int)((long)written + c);
                    } while (buf.hasRemaining() && c > 0L);
                    chunkRemaining -= (long)written;
                    if (buf.hasRemaining()) {
                        long l = written;
                        return l;
                    }
                    read += written;
                    remaining -= (long)written;
                }
            }
            if (chunkRemaining > 0L) {
                long c = 0L;
                remaining = Math.min(chunkRemaining, remaining);
                do {
                    if ((c = this.delegate.transferTo(remaining, throughBuffer, target)) <= 0L) continue;
                    read = (int)((long)read + c);
                    chunkRemaining -= c;
                    remaining -= c;
                } while (c > 0L && remaining > 0L);
                if (c == -1L) {
                    newVal |= 0x1000000000000000L;
                }
                if (chunkRemaining == 0L) {
                    newVal |= 0x200000000000000L;
                }
            }
            long l = read;
            return l;
        }
        finally {
            this.exitRead(chunkRemaining, newVal & 0x1C00000000000000L, (newVal ^ 0xFFFFFFFFFFFFFFFFL) & 0xC00000000000000L);
        }
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.read(dsts[i]);
        }
        return 0L;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        long newVal;
        long oldVal = this.enterRead();
        if (Bits.anyAreSet((long)oldVal, (long)0x1000000000000000L)) {
            return -1;
        }
        if (Bits.anyAreSet((long)oldVal, (long)0x4000000000000000L)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet((long)oldVal, (long)0x1E00000000000000L)) {
            newVal = this.readRawData(oldVal);
        } else {
            assert ((oldVal & MASK_COUNT) != 0L);
            newVal = oldVal;
        }
        long chunkRemaining = newVal & MASK_COUNT;
        int originalLimit = dst.limit();
        try {
            if (Bits.anyAreSet((long)newVal, (long)0x1E00000000000000L)) {
                int n = 0;
                return n;
            }
            int read = 0;
            Pooled<ByteBuffer> buffer = this.rawData;
            if (buffer != null) {
                ByteBuffer buf = (ByteBuffer)buffer.getResource();
                int remaining = dst.remaining();
                if (chunkRemaining > (long)remaining) {
                    int orig = buf.limit();
                    buf.limit(buf.position() + remaining);
                    dst.put(buf);
                    buf.limit(orig);
                    chunkRemaining -= (long)remaining;
                    int n = remaining;
                    return n;
                }
                int old = buf.limit();
                buf.limit((int)Math.min((long)old, (long)buf.position() + chunkRemaining));
                try {
                    dst.put(buf);
                }
                finally {
                    buf.limit(old);
                }
                read = (int)((long)read + chunkRemaining);
                chunkRemaining = 0L;
            }
            if (chunkRemaining > 0L) {
                if (chunkRemaining < (long)dst.remaining()) {
                    dst.limit((int)((long)dst.position() + chunkRemaining));
                }
                int c = 0;
                do {
                    if ((c = this.delegate.read(dst)) <= 0) continue;
                    read += c;
                    chunkRemaining -= (long)c;
                } while (c > 0 && chunkRemaining > 0L);
                if (c == -1) {
                    newVal |= 0x1000000000000000L;
                }
                if (chunkRemaining == 0L) {
                    newVal |= 0x200000000000000L;
                }
            }
            int n = read;
            return n;
        }
        finally {
            dst.limit(originalLimit);
            this.exitRead(chunkRemaining, newVal & 0x1C00000000000000L, (newVal ^ 0xFFFFFFFFFFFFFFFFL) & 0xC00000000000000L);
        }
    }

    public long readRawData(long oldVal) throws IOException {
        int c;
        byte b;
        long newVal = oldVal;
        long chunkRemaining = newVal & MASK_COUNT;
        Pooled buffer = this.rawData;
        if (buffer == null) {
            buffer = this.rawData = this.bufferPool.allocate();
            ((ByteBuffer)buffer.getResource()).clear();
        }
        ByteBuffer buf = (ByteBuffer)buffer.getResource();
        buf.compact();
        if (Bits.allAreClear((long)newVal, (long)0xC00000000000000L) && chunkRemaining == 0L) {
            return newVal |= 0x1000000000000000L;
        }
        while (Bits.anyAreSet((long)newVal, (long)0x200000000000000L)) {
            while (buf.hasRemaining()) {
                b = buf.get();
                if (b != 10) continue;
                newVal = newVal & 0xFDFFFFFFFFFFFFFFL | 0x800000000000000L;
                break;
            }
            if (!Bits.anyAreSet((long)newVal, (long)0x200000000000000L)) continue;
            c = this.delegate.read(buf);
            buf.flip();
            if (c == -1) {
                return newVal |= 0x1000000000000000L;
            }
            if (c != 0) continue;
            return newVal;
        }
        while (Bits.anyAreSet((long)newVal, (long)0x800000000000000L)) {
            while (buf.hasRemaining()) {
                b = buf.get();
                if (b >= 48 && b <= 57 || b >= 97 && b <= 102 || b >= 65 && b < 70) {
                    chunkRemaining <<= 4;
                    chunkRemaining += (long)Integer.parseInt("" + (char)b, 16);
                    continue;
                }
                newVal = newVal & 0xF7FFFFFFFFFFFFFFL | 0x400000000000000L;
                break;
            }
            if (!Bits.anyAreSet((long)newVal, (long)0x800000000000000L)) continue;
            buf.compact();
            c = this.delegate.read(buf);
            buf.flip();
            if (c == -1) {
                return newVal |= 0x1000000000000000L;
            }
            if (c != 0) continue;
            return newVal;
        }
        while (Bits.anyAreSet((long)newVal, (long)0x400000000000000L)) {
            while (buf.hasRemaining()) {
                if (((ByteBuffer)buffer.getResource()).get() != 10) continue;
                newVal &= 0xFBFFFFFFFFFFFFFFL;
                break;
            }
            if (!Bits.anyAreSet((long)newVal, (long)0x400000000000000L)) continue;
            c = this.delegate.read(buf);
            buf.flip();
            if (c == -1) {
                return newVal |= 0x1000000000000000L;
            }
            if (c != 0) continue;
            return newVal;
        }
        if (Bits.allAreClear((long)newVal, (long)0xE00000000000000L) && chunkRemaining == 0L) {
            newVal |= 0x1000000000000000L;
            if (buf.hasRemaining()) {
                this.delegate.unget(buffer);
                buffer = null;
            }
        }
        return newVal & (MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL) | chunkRemaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendReads() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet((long)val, (long)0x6000000000000000L)) {
            return;
        }
        try {
            this.delegate.suspendReads();
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeReads() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet((long)val, (long)0x6000000000000000L)) {
            return;
        }
        try {
            if (val == 0L) {
                this.delegate.wakeupReads();
            } else {
                this.delegate.resumeReads();
            }
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    public boolean isReadResumed() {
        return Bits.allAreClear((long)this.state, (long)0x4000000000000000L) && this.delegate.isReadResumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupReads() {
        long val = this.enterSuspendResume();
        if (Bits.anyAreSet((long)val, (long)0x6000000000000000L)) {
            return;
        }
        try {
            this.delegate.wakeupReads();
        }
        finally {
            this.exitSuspendResume(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        long val = this.enterShutdownReads();
        if (Bits.allAreSet((long)val, (long)0x4000000000000000L)) {
            return;
        }
        this.exitShutdownReads(val);
    }

    public void awaitReadable() throws IOException {
        long val = this.state;
        if (Bits.allAreSet((long)val, (long)0x4000000000000000L) || val == 0L) {
            return;
        }
        this.delegate.awaitReadable();
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        long val = this.state;
        if (Bits.allAreSet((long)val, (long)0x4000000000000000L) || val == 0L) {
            return;
        }
        this.delegate.awaitReadable(time, timeUnit);
    }

    public XnioExecutor getReadThread() {
        return this.delegate.getReadThread();
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public boolean isOpen() {
        return Bits.allAreClear((long)this.state, (long)0x4000000000000000L);
    }

    public void close() throws IOException {
        this.shutdownReads();
    }

    public boolean supportsOption(Option<?> option) {
        return this.configurable && this.delegate.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)(this.configurable ? this.delegate.getOption(option) : null);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)(this.configurable ? this.delegate.setOption(option, value) : null);
    }

    public StreamSourceChannel getChannel() {
        return this.delegate;
    }

    private long enterShutdownReads() {
        long newVal;
        long oldVal;
        do {
            if (!Bits.anyAreSet((long)(oldVal = this.state), (long)0x4000000000000000L)) continue;
            return oldVal;
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | 0x4000000000000000L | 0x2000000000000000L));
        return oldVal;
    }

    private void exitShutdownReads(long oldVal) {
        boolean wasFinished = Bits.allAreSet((long)oldVal, (long)0x1000000000000000L);
        boolean wasInSusRes = Bits.allAreSet((long)oldVal, (long)0x2000000000000000L);
        boolean wasEntered = Bits.allAreSet((long)oldVal, (long)Long.MIN_VALUE);
        if (!wasInSusRes) {
            long newVal = oldVal & 0xDFFFFFFFFFFFFFFFL;
            while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
                oldVal = this.state;
                newVal = oldVal & 0xDFFFFFFFFFFFFFFFL;
            }
            if (!wasEntered) {
                if (!wasFinished && Bits.allAreClear((long)newVal, (long)MASK_COUNT)) {
                    this.callFinish();
                }
                this.callClosed();
            }
        }
    }

    private long enterSuspendResume() {
        long newVal;
        long oldVal;
        do {
            if (!Bits.anyAreSet((long)(oldVal = this.state), (long)0x6000000000000000L)) continue;
            return oldVal;
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | 0x2000000000000000L));
        return oldVal;
    }

    private void exitSuspendResume(long oldVal) {
        boolean wasFinished = Bits.allAreSet((long)oldVal, (long)0x1000000000000000L);
        boolean wasClosed = Bits.allAreClear((long)oldVal, (long)0x4000000000000000L);
        boolean wasEntered = Bits.allAreSet((long)oldVal, (long)Long.MIN_VALUE);
        long newVal = oldVal & 0xDFFFFFFFFFFFFFFFL;
        while (!stateUpdater.compareAndSet(this, oldVal, newVal)) {
            oldVal = this.state;
            newVal = oldVal & 0xDFFFFFFFFFFFFFFFL;
        }
        if (!wasEntered) {
            if (!wasFinished && Bits.allAreClear((long)newVal, (long)MASK_COUNT)) {
                this.callFinish();
            }
            if (!wasClosed && Bits.allAreSet((long)newVal, (long)0x4000000000000000L)) {
                this.callClosed();
            }
        }
    }

    private long enterRead() {
        long newVal;
        long oldVal;
        do {
            if (Bits.allAreSet((long)(oldVal = this.state), (long)0x4000000000000000L) || Bits.allAreSet((long)oldVal, (long)0x1000000000000000L)) {
                return oldVal;
            }
            if (!Bits.allAreSet((long)oldVal, (long)Long.MIN_VALUE)) continue;
            throw new ConcurrentStreamChannelAccessException();
        } while (!stateUpdater.weakCompareAndSet(this, oldVal, newVal = oldVal | Long.MIN_VALUE));
        return oldVal;
    }

    private void exitRead(long chunkSize, long setFlags, long clearFlags) {
        long newVal;
        long oldVal;
        while (!stateUpdater.compareAndSet(this, oldVal = this.state, newVal = (oldVal | setFlags & (clearFlags ^ 0xFFFFFFFFFFFFFFFFL) & (chunkSize | MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL)) & Long.MAX_VALUE)) {
        }
        if (this.rawData != null && !((ByteBuffer)this.rawData.getResource()).hasRemaining()) {
            this.rawData.free();
            this.rawData = null;
        }
        if (Bits.allAreSet((long)newVal, (long)0x4000000000000000L)) {
            this.callClosed();
        }
        if (Bits.allAreClear((long)oldVal, (long)0x1000000000000000L) && Bits.allAreSet((long)newVal, (long)0x1000000000000000L)) {
            this.callFinish();
        }
    }

    private void callFinish() {
        ChannelListeners.invokeChannelListener((Channel)((Object)this), this.finishListener);
    }

    private void callClosed() {
        ChannelListeners.invokeChannelListener((Channel)((Object)this), (ChannelListener)this.closeSetter.get());
    }
}

