/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.SecureHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public final class HeaderMap
implements Iterable<String> {
    private final Map<String, HeaderValue> values = new SecureHashMap<String, HeaderValue>();

    @Override
    public Iterator<String> iterator() {
        final Iterator<HeaderValue> iterator = this.values.values().iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return ((HeaderValue)iterator.next()).getName();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public String getFirst(String headerName) {
        Deque deque = this.values.get(headerName.toLowerCase(Locale.US));
        return deque == null ? null : (String)deque.peekFirst();
    }

    public String getLast(String headerName) {
        Deque deque = this.values.get(headerName.toLowerCase(Locale.US));
        return deque == null ? null : (String)deque.peekLast();
    }

    public Deque<String> get(String headerName) {
        return this.values.get(headerName.toLowerCase(Locale.US));
    }

    public void add(String headerName, String headerValue) {
        String key = headerName.toLowerCase(Locale.US);
        HeaderValue value = this.values.get(key);
        if (value == null) {
            this.values.put(key, new HeaderValue(headerName, headerValue));
        } else {
            value.add(headerValue);
        }
    }

    public void addAll(String headerName, Collection<String> headerValues) {
        String key = headerName.toLowerCase(Locale.US);
        HeaderValue value = this.values.get(key);
        if (value == null) {
            this.values.put(key, new HeaderValue(headerName, headerValues));
        } else {
            value.addAll(headerValues);
        }
    }

    public void addAll(HeaderMap other) {
        for (Map.Entry<String, HeaderValue> entry : other.values.entrySet()) {
            String key = entry.getKey();
            HeaderValue value = entry.getValue();
            HeaderValue target = this.values.get(key);
            if (target == null) {
                this.values.put(key, new HeaderValue(value.getName(), value));
                continue;
            }
            target.addAll(value);
        }
    }

    public void put(String headerName, String headerValue) {
        String key = headerName.toLowerCase(Locale.US);
        HeaderValue value = new HeaderValue(headerName, headerValue);
        this.values.put(key, value);
    }

    public void putAll(String headerName, Collection<String> headerValues) {
        String key = headerName.toLowerCase(Locale.US);
        HeaderValue deque = new HeaderValue(headerName, headerValues);
        this.values.put(key, deque);
    }

    public Collection<String> remove(String headerName) {
        return this.values.remove(headerName);
    }

    public void lock() {
    }

    public boolean contains(String headerName) {
        HeaderValue value = this.values.get(headerName.toLowerCase(Locale.US));
        return value != null && !value.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeaderMap strings = (HeaderMap)o;
        return !(this.values != null ? !((Object)this.values).equals(strings.values) : strings.values != null);
    }

    public int hashCode() {
        return this.values != null ? ((Object)this.values).hashCode() : 0;
    }

    public String toString() {
        return "HeaderMap{values=" + this.values + '}';
    }

    static class HeaderValue
    extends ArrayDeque<String> {
        private final String name;

        HeaderValue(String name) {
            super(1);
            this.name = name;
        }

        HeaderValue(String name, String singleValue) {
            this(name);
            this.add(singleValue);
        }

        HeaderValue(String name, Collection<String> c) {
            super(c);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeaderValue strings = (HeaderValue)o;
            if (this.name != null ? !this.name.equals(strings.name) : strings.name != null) {
                return false;
            }
            if (strings.size() != this.size()) {
                return false;
            }
            Iterator i1 = this.iterator();
            Iterator i2 = strings.iterator();
            while (i1.hasNext()) {
                String n2;
                String n1 = (String)i1.next();
                if (n1.equals(n2 = (String)i2.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

