/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;

public class StringWriteChannelListener
implements ChannelListener<StreamSinkChannel> {
    private final ByteBuffer buffer;

    public StringWriteChannelListener(String string) {
        this.buffer = ByteBuffer.wrap(string.getBytes());
    }

    public void setup(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.getWriteSetter().set((ChannelListener)this);
                channel.resumeWrites();
            } else {
                this.writeDone(channel);
            }
        }
        catch (IOException e) {
            IoUtils.safeClose((Closeable)channel);
        }
    }

    public void handleEvent(StreamSinkChannel channel) {
        try {
            int c;
            do {
                c = channel.write(this.buffer);
            } while (this.buffer.hasRemaining() && c > 0);
            if (this.buffer.hasRemaining()) {
                channel.resumeWrites();
                return;
            }
            this.writeDone(channel);
        }
        catch (IOException e) {
            IoUtils.safeClose((Closeable)channel);
        }
    }

    protected void writeDone(StreamSinkChannel channel) {
        IoUtils.safeClose((Closeable)channel);
    }
}

