/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.XnioExecutor;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.nio.AbstractNioChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioXnioWorker;
import org.xnio.nio.SelectorUtils;
import org.xnio.nio.WorkerThread;

abstract class AbstractNioStreamSourceChannel<C extends AbstractNioStreamSourceChannel<C>>
extends AbstractNioChannel<C>
implements StreamSourceChannel {
    private static final String FQCN = AbstractNioStreamSourceChannel.class.getName();
    private volatile NioHandle<C> readHandle;
    private volatile int readTimeout = 0;
    private volatile long lastRead;
    private final ChannelListener.SimpleSetter<C> readSetter = new ChannelListener.SimpleSetter();
    private static final AtomicIntegerFieldUpdater<AbstractNioStreamSourceChannel> readTimeoutUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractNioStreamSourceChannel.class, "readTimeout");
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.READ_TIMEOUT).create();

    AbstractNioStreamSourceChannel(NioXnioWorker worker) throws ClosedChannelException {
        super(worker);
    }

    void start() throws ClosedChannelException {
        WorkerThread readThread = this.worker.chooseOptional(false);
        this.readHandle = readThread == null ? null : readThread.addChannel((AbstractSelectableChannel)((Object)this.getReadChannel()), this.typed(), 0, this.readSetter);
        this.lastRead = System.nanoTime();
    }

    protected abstract ScatteringByteChannel getReadChannel();

    public final ChannelListener.Setter<? extends C> getReadSetter() {
        return this.readSetter;
    }

    public final void suspendReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Suspend reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle != null) {
            readHandle.suspend();
        }
    }

    public final void resumeReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Resume reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        readHandle.resume(1);
    }

    public boolean isReadResumed() {
        NioHandle<C> readHandle = this.readHandle;
        return readHandle != null && readHandle.isResumed(1);
    }

    public void wakeupReads() {
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Wake up reads on %s", (Object)this);
        NioHandle<C> readHandle = this.readHandle;
        if (readHandle == null) {
            throw new IllegalArgumentException("No thread configured");
        }
        readHandle.resume(1);
        readHandle.execute();
    }

    public final void awaitReadable() throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getReadChannel()), 1);
    }

    public final void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.worker.getXnio(), (SelectableChannel)((Object)this.getReadChannel()), 1, time, timeUnit);
    }

    public XnioExecutor getReadThread() {
        NioHandle<C> handle = this.readHandle;
        return handle == null ? null : handle.getWorkerThread();
    }

    public final long transferTo(long position, long count, FileChannel target) throws IOException {
        long res = target.transferFrom(this.getReadChannel(), position, count);
        if (res > 0L) {
            this.lastRead = System.nanoTime();
        } else {
            int timeout = this.readTimeout;
            if (timeout > 0 && (System.nanoTime() - this.lastRead) / 1000000L > (long)timeout) {
                throw new ReadTimeoutException("Read timed out");
            }
        }
        return res;
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)((Object)this), (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)target);
    }

    public int read(ByteBuffer dst) throws IOException {
        int res;
        try {
            res = this.getReadChannel().read(dst);
        }
        catch (ClosedChannelException e) {
            return -1;
        }
        if (res > 0) {
            this.lastRead = System.nanoTime();
        } else {
            int timeout = this.readTimeout;
            if (timeout > 0 && (System.nanoTime() - this.lastRead) / 1000000L > (long)timeout) {
                throw new ReadTimeoutException("Read timed out");
            }
        }
        return res;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res;
        if (length == 1) {
            return this.read(dsts[offset]);
        }
        try {
            res = this.getReadChannel().read(dsts, offset, length);
        }
        catch (ClosedChannelException e) {
            return -1L;
        }
        if (res > 0L) {
            this.lastRead = System.nanoTime();
        } else {
            int timeout = this.readTimeout;
            if (timeout > 0 && (System.nanoTime() - this.lastRead) / 1000000L > (long)timeout) {
                throw new ReadTimeoutException("Read timed out");
            }
        }
        return res;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.READ_TIMEOUT) {
            int newValue = (Integer)Options.READ_TIMEOUT.cast(value, (Object)0);
            return (T)option.cast((Object)readTimeoutUpdater.getAndSet(this, newValue));
        }
        return null;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.READ_TIMEOUT) {
            return (T)option.cast((Object)this.readTimeout);
        }
        return null;
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    protected void cancelReadKey() {
        if (this.readHandle != null) {
            this.readHandle.cancelKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void migrateTo(NioXnioWorker worker) throws ClosedChannelException {
        boolean ok = false;
        WorkerThread readThread = worker.chooseOptional(false);
        NioHandle newReadHandle = readThread == null ? null : readThread.addChannel((AbstractSelectableChannel)((Object)this.getReadChannel()), this.typed(), 0, this.readSetter);
        try {
            this.cancelReadKey();
            ok = true;
        }
        finally {
            if (ok) {
                this.readHandle = newReadHandle;
                super.migrateTo(worker);
            } else if (newReadHandle != null) {
                newReadHandle.cancelKey();
            }
        }
    }
}

