/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.charset;

import io.undertow.servlet.Servlets;
import io.undertow.servlet.test.charset.EchoServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class UnmappableCharacterTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(Servlets.servlet((String)"servlet", EchoServlet.class).addMapping("/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmappableCharacters() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            String message = "abc\u010d\u0161\u017egg";
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext?message=" + message);
            CloseableHttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"abc???gg", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

