/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.defaultservlet;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.path.ServletPathMappingTestCase;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SecurityRedirectTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ServletPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(SecurityRedirectTestCase.class)).addWelcomePages(new String[]{"index.html"}).setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("BASIC", "Test Realm")).addSecurityConstraint(((SecurityConstraint)new SecurityConstraint().addRoleAllowed("role1")).addWebResourceCollection(new WebResourceCollection().addUrlPatterns(new String[]{"/index.html", "/filterpath/*"})));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecurityWithWelcomeFileRedirect() throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().disableRedirectHandling().build();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)302L, (long)result.getStatusLine().getStatusCode());
            Header[] values = result.getHeaders(Headers.LOCATION.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(DefaultServer.getDefaultServerURL() + "/servletContext/"), (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user1:password1".getBytes(), (boolean)false));
            result = client.execute((HttpUriRequest)get);
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)response.contains("Redirected home page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecurityWithoutWelcomeFileRedirect() throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().disableRedirectHandling().build();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/filterpath");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/filterpath/");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/filterpath");
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user1:password1".getBytes(), (boolean)false));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)302L, (long)result.getStatusLine().getStatusCode());
            values = result.getHeaders(Headers.LOCATION.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(DefaultServer.getDefaultServerURL() + "/servletContext/filterpath/"), (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/filterpath/filtered.txt");
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user1:password1".getBytes(), (boolean)false));
            result = client.execute((HttpUriRequest)get);
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertTrue((boolean)response.equals("Stuart"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

