/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async.onComplete;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class OnCompleteServlet
extends HttpServlet {
    public static final BlockingQueue<String> QUEUE = new LinkedBlockingDeque<String>();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        final AsyncContext ctx = req.startAsync();
        ctx.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
                QUEUE.add("onComplete");
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                QUEUE.add("onTimeout");
            }

            public void onError(AsyncEvent event) throws IOException {
                QUEUE.add("onError");
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                QUEUE.add("onStartAsync");
            }
        });
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ctx.dispatch("/message");
            }
        });
        thread.start();
    }
}

