/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async.onError;

import io.undertow.servlet.test.listener.request.async.onError.AsyncEventListener;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AsyncServlet5
extends HttpServlet {
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AsyncContext ctx = req.startAsync();
        resp.setContentType("text/event-stream");
        resp.setHeader("Cache-Control", "no-cache");
        ctx.setTimeout(10000L);
        ctx.addListener((AsyncListener)new AsyncEventListener(){

            @Override
            public void onError(AsyncEvent event) throws IOException {
                super.onError(event);
                latch.countDown();
            }
        });
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ScheduledFuture<?> scheduledFuture = AsyncServlet5.this.executorService.scheduleAtFixedRate(new Job(ctx), 0L, 1L, TimeUnit.SECONDS);
                try {
                    latch.await(11L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                scheduledFuture.cancel(true);
                ctx.complete();
            }
        });
        t.start();
    }

    private class Job
    implements Runnable {
        private final AsyncContext asyncContext;

        Job(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
        }

        @Override
        public void run() {
            try {
                ServletResponse response = this.asyncContext.getResponse();
                response.getOutputStream().print(this.getMessage());
                response.flushBuffer();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private String getMessage() {
            return "data:" + LocalDateTime.now() + "\n\n";
        }
    }
}

