/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.form;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.security.form.FormLoginServlet;
import io.undertow.servlet.test.security.form.SaveOriginalPostRequestTestCase;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FormAuthenticationRootContextRedirectTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler path = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo securedIndexRequestDumper = new ServletInfo("SecuredIndexRequestDumperServlet", SaveOriginalPostRequestTestCase.RequestDumper.class).setServletSecurityInfo((ServletSecurityInfo)new ServletSecurityInfo().addRoleAllowed("role1")).addMapping("/index.html");
        ServletInfo loginFormServlet = new ServletInfo("loginPage", FormLoginServlet.class).setServletSecurityInfo((ServletSecurityInfo)new ServletSecurityInfo().addRoleAllowed("group1")).addMapping("/FormLoginServlet");
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        SecurityConstraint securityConstraint = new SecurityConstraint();
        WebResourceCollection webResourceCollection = new WebResourceCollection();
        webResourceCollection.addUrlPattern("/*");
        securityConstraint.addWebResourceCollection(webResourceCollection);
        securityConstraint.addRoleAllowed("role1");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).addWelcomePage("index.html").setResourceManager((ResourceManager)new TestResourceLoader(SaveOriginalPostRequestTestCase.class)).addSecurityConstraint(securityConstraint).setLoginConfig(new LoginConfig("FORM", "Test Realm", "/FormLoginServlet", "/error.html")).addServlets(new ServletInfo[]{loginFormServlet, securedIndexRequestDumper});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    @Test
    public void test2() throws IOException {
        TestHttpClient client = new TestHttpClient();
        HttpClientContext context = HttpClientContext.create();
        String uri = DefaultServer.getDefaultServerURL() + "/servletContext";
        HttpGet request = new HttpGet(uri);
        CloseableHttpResponse result = client.execute((HttpUriRequest)request, (HttpContext)context);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)(DefaultServer.getDefaultServerURL() + "/servletContext/"), (Object)this.requestedUri(context, uri));
        Assert.assertTrue((boolean)HttpClientUtils.readResponse((HttpResponse)result).startsWith("j_security_check"));
    }

    private String requestedUri(HttpClientContext context, String original) {
        if (context.getRedirectLocations() == null) {
            return original;
        }
        URI uri = (URI)context.getRedirectLocations().get(context.getRedirectLocations().size() - 1);
        return uri == null ? original : uri.toString();
    }
}

