/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.wrapper;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;

public class NonStandardResponseWrapper
implements HttpServletResponse {
    private ServletResponse response;

    public NonStandardResponseWrapper(ServletResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("Response cannot be null");
        }
        this.response = response;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(ServletResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("Response cannot be null");
        }
        this.response = response;
    }

    public void setCharacterEncoding(String charset) {
        this.response.setCharacterEncoding(charset);
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    public void setContentLength(int len) {
        this.response.setContentLength(len);
    }

    public void setContentLengthLong(long len) {
        this.response.setContentLengthLong(len);
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public void setBufferSize(int size) {
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void reset() {
        this.response.reset();
    }

    public void resetBuffer() {
        this.response.resetBuffer();
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public boolean isWrapperFor(ServletResponse wrapped) {
        if (this.response == wrapped) {
            return true;
        }
        if (this.response instanceof ServletResponseWrapper) {
            return ((ServletResponseWrapper)this.response).isWrapperFor(wrapped);
        }
        return false;
    }

    public boolean isWrapperFor(Class<?> wrappedType) {
        if (!ServletResponse.class.isAssignableFrom(wrappedType)) {
            throw new IllegalArgumentException("Given class " + wrappedType.getName() + " not a subinterface of " + ServletResponse.class.getName());
        }
        if (wrappedType.isAssignableFrom(this.response.getClass())) {
            return true;
        }
        if (this.response instanceof ServletResponseWrapper) {
            return ((ServletResponseWrapper)this.response).isWrapperFor(wrappedType);
        }
        return false;
    }

    private HttpServletResponse _getHttpServletResponse() {
        return (HttpServletResponse)this.response;
    }

    public void addCookie(Cookie cookie) {
        this._getHttpServletResponse().addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this._getHttpServletResponse().containsHeader(name);
    }

    public String encodeURL(String url) {
        return this._getHttpServletResponse().encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this._getHttpServletResponse().encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this._getHttpServletResponse().encodeUrl(url);
    }

    public String encodeRedirectUrl(String url) {
        return this._getHttpServletResponse().encodeRedirectUrl(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this._getHttpServletResponse().sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this._getHttpServletResponse().sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this._getHttpServletResponse().sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this._getHttpServletResponse().setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this._getHttpServletResponse().addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this._getHttpServletResponse().setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this._getHttpServletResponse().addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this._getHttpServletResponse().setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this._getHttpServletResponse().addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        this._getHttpServletResponse().setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this._getHttpServletResponse().setStatus(sc, sm);
    }

    public int getStatus() {
        return this._getHttpServletResponse().getStatus();
    }

    public String getHeader(String name) {
        return this._getHttpServletResponse().getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return this._getHttpServletResponse().getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this._getHttpServletResponse().getHeaderNames();
    }
}

