/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.util;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CookieHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.form.FormEncodedDataHandler;
import io.undertow.server.handlers.form.MultiPartHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.test.utils.DefaultServer;
import javax.servlet.ServletException;

public class DeploymentUtils {
    public static Deployment setupServlet(ServletInfo ... servlets) {
        PathHandler pathHandler = new PathHandler();
        FormEncodedDataHandler formEncodedDataHandler = new FormEncodedDataHandler((HttpHandler)pathHandler);
        MultiPartHandler multiPartHandler = new MultiPartHandler((HttpHandler)formEncodedDataHandler);
        CookieHandler cookieHandler = new CookieHandler((HttpHandler)multiPartHandler);
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlets(servlets);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        try {
            pathHandler.addPath(builder.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        DefaultServer.setRootHandler((HttpHandler)cookieHandler);
        return manager.getDeployment();
    }
}

