/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.errorpage;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.errorpage.ChildException;
import io.undertow.servlet.test.errorpage.ErrorServlet;
import io.undertow.servlet.test.errorpage.ParentException;
import io.undertow.servlet.test.errorpage.PathServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ErrorPageTestCase {
    @BeforeClass
    public static void setup() throws IOException, ServletException {
        ServletContainer container = ServletContainer.Factory.newInstance();
        PathHandler root = new PathHandler();
        DefaultServer.setRootHandler((HttpHandler)root);
        DeploymentInfo builder1 = new DeploymentInfo();
        builder1.addServlet(new ServletInfo("error", ErrorServlet.class).addMapping("/error"));
        builder1.addServlet(new ServletInfo("path", PathServlet.class).addMapping("/*"));
        builder1.addErrorPage(new ErrorPage("/defaultErrorPage"));
        builder1.addErrorPage(new ErrorPage("/404", 404));
        builder1.addErrorPage(new ErrorPage("/500", 500));
        builder1.addErrorPage(new ErrorPage("/parentException", ParentException.class));
        builder1.addErrorPage(new ErrorPage("/childException", ChildException.class));
        builder1.addErrorPage(new ErrorPage("/runtimeException", RuntimeException.class));
        builder1.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ErrorPageTestCase.class.getClassLoader()).setContextPath("/servletContext1").setDeploymentName("servletContext1.war");
        DeploymentManager manager1 = container.addDeployment(builder1);
        manager1.deploy();
        root.addPath(builder1.getContextPath(), manager1.start());
        DeploymentInfo builder2 = new DeploymentInfo();
        builder2.addServlet(new ServletInfo("error", ErrorServlet.class).addMapping("/error"));
        builder2.addServlet(new ServletInfo("path", PathServlet.class).addMapping("/*"));
        builder2.addErrorPage(new ErrorPage("/404", 404));
        builder2.addErrorPage(new ErrorPage("/501", 501));
        builder2.addErrorPage(new ErrorPage("/parentException", ParentException.class));
        builder2.addErrorPage(new ErrorPage("/childException", ChildException.class));
        builder2.addErrorPage(new ErrorPage("/runtimeException", RuntimeException.class));
        builder2.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ErrorPageTestCase.class.getClassLoader()).setContextPath("/servletContext2").setDeploymentName("servletContext2.war");
        DeploymentManager manager2 = container.addDeployment(builder2);
        manager2.deploy();
        root.addPath(builder2.getContextPath(), manager2.start());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorPages() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(1, client, 404, null, "/404");
            this.runTest(1, client, 500, null, "/500");
            this.runTest(1, client, 501, null, "/defaultErrorPage");
            this.runTest(1, client, null, ParentException.class, "/parentException");
            this.runTest(1, client, null, ChildException.class, "/childException");
            this.runTest(1, client, null, RuntimeException.class, "/runtimeException");
            this.runTest(1, client, null, IllegalStateException.class, "/runtimeException");
            this.runTest(1, client, null, Exception.class, "/defaultErrorPage");
            this.runTest(1, client, null, IOException.class, "/defaultErrorPage");
            this.runTest(1, client, null, ServletException.class, "/defaultErrorPage");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorPagesWithNoDefaultErrorPage() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(2, client, 404, null, "/404");
            this.runTest(2, client, 501, null, "/501");
            this.runTest(2, client, 500, null, "<html><head><title>Error</title></head><body>Internal Server Error</body></html>");
            this.runTest(2, client, null, ParentException.class, "/parentException");
            this.runTest(2, client, null, ChildException.class, "/childException");
            this.runTest(2, client, null, RuntimeException.class, "/runtimeException");
            this.runTest(2, client, null, IllegalStateException.class, "/runtimeException");
            this.runTest(2, client, null, Exception.class, "<html><head><title>Error</title></head><body>Internal Server Error</body></html>");
            this.runTest(2, client, null, IOException.class, "<html><head><title>Error</title></head><body>Internal Server Error</body></html>");
            this.runTest(2, client, null, ServletException.class, "<html><head><title>Error</title></head><body>Internal Server Error</body></html>");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void runTest(int deploymentNo, TestHttpClient client, Integer statusCode, Class<?> exception, String expected) throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext" + deploymentNo + "/error?" + (statusCode != null ? "statusCode=" + statusCode : "exception=" + exception.getName()));
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)(statusCode == null ? 500L : (long)statusCode.intValue()), (long)result.getStatusLine().getStatusCode());
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)expected, (Object)response);
    }
}

