/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.streams;

import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.streams.AsyncOutputStreamServlet;
import io.undertow.servlet.test.streams.BlockingOutputStreamServlet;
import io.undertow.servlet.test.streams.ContentLengthCloseFlushServlet;
import io.undertow.servlet.test.util.DeploymentUtils;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletOutputStreamTestCase {
    public static String message;
    public static final String HELLO_WORLD = "Hello World";
    public static final String BLOCKING_SERVLET = "blockingOutput";
    public static final String ASYNC_SERVLET = "asyncOutput";
    public static final String CONTENT_LENGTH_SERVLET = "contentLength";

    @BeforeClass
    public static void setup() throws ServletException {
        DeploymentUtils.setupServlet(new ServletInfo(BLOCKING_SERVLET, BlockingOutputStreamServlet.class).addMapping("/blockingOutput"), new ServletInfo(ASYNC_SERVLET, AsyncOutputStreamServlet.class).addMapping("/asyncOutput").setAsyncSupported(true), new ServletInfo(CONTENT_LENGTH_SERVLET, ContentLengthCloseFlushServlet.class).addMapping("/contentLength"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAndCloseWithContentLength() throws Exception {
        TestHttpClient client = new TestHttpClient();
        try {
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext/" + CONTENT_LENGTH_SERVLET;
            HttpGet get = new HttpGet(uri);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"a", (Object)response);
            get = new HttpGet(uri);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"OK", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    @Test
    public void testBlockingServletOutputStream() {
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 1000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString();
                this.runTest(message, BLOCKING_SERVLET, false, false, 1);
                this.runTest(message, BLOCKING_SERVLET, true, false, 10);
                this.runTest(message, BLOCKING_SERVLET, false, true, 3);
                this.runTest(message, BLOCKING_SERVLET, true, true, 7);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    @Test
    public void testAsyncServletOutputStream() {
        StringBuilder builder = new StringBuilder(1000 * HELLO_WORLD.length());
        for (int i = 0; i < 10; ++i) {
            try {
                for (int j = 0; j < 10000; ++j) {
                    builder.append(HELLO_WORLD);
                }
                String message = builder.toString();
                this.runTest(message, ASYNC_SERVLET, false, false, 1);
                this.runTest(message, ASYNC_SERVLET, true, false, 10);
                this.runTest(message, ASYNC_SERVLET, false, true, 3);
                this.runTest(message, ASYNC_SERVLET, true, true, 7);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("test failed with i equal to " + i, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String message, String url, boolean flush, boolean close, int reps) throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            ServletOutputStreamTestCase.message = message;
            String uri = DefaultServer.getDefaultServerURL() + "/servletContext/" + url + "?reps=" + reps + "&";
            if (flush) {
                uri = uri + "flush=true&";
            }
            if (close) {
                uri = uri + "close=true&";
            }
            HttpGet get = new HttpGet(uri);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            StringBuilder builder = new StringBuilder(reps * message.length());
            for (int j = 0; j < reps; ++j) {
                builder.append(message);
            }
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)builder.toString(), (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

