/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import org.jasig.cas.authentication.principal.SimpleService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.flow.AbstractCasLoginAction;
import org.jasig.cas.web.flow.util.ContextUtils;
import org.jasig.cas.web.util.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class GenerateServiceTicketAction
extends AbstractCasLoginAction {
    protected Event doExecuteInternal(RequestContext context, String ticketGrantingTicketId, String service, boolean gateway, boolean renew, boolean warn) {
        String ticketGrantingTicketFromRequest = (String)ContextUtils.getAttribute(context, "ticketGrantingTicketId");
        try {
            String serviceTicketId = this.getCentralAuthenticationService().grantServiceTicket(ticketGrantingTicketFromRequest != null ? ticketGrantingTicketFromRequest : ticketGrantingTicketId, new SimpleService(WebUtils.stripJsessionFromUrl(service)));
            ContextUtils.addAttribute(context, "ticket", serviceTicketId);
            return this.success();
        }
        catch (TicketException e) {
            if (gateway) {
                return this.gateway();
            }
            return this.error();
        }
    }
}

