/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.WeakHashMap;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.DynamicAOPStrategy;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.MethodInterceptors;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.HotSwapper;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.InstrumentorFactory;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.JoinpointFullClassifier;
import org.jboss.aop.instrument.JoinpointStatusUpdate;

public class HotSwapStrategy
implements DynamicAOPStrategy {
    private HotSwapper hotSwapper;
    private Collection joinpointUpdates;
    private Instrumentor instrumentor;

    public HotSwapStrategy(HotSwapper hotSwapper) {
        this.hotSwapper = hotSwapper;
        this.joinpointUpdates = new ArrayList();
        this.instrumentor = InstrumentorFactory.getInstrumentor(AspectManager.instance(), this.getJoinpointClassifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void interceptorChainsUpdated() {
        Collection collection = this.joinpointUpdates;
        synchronized (collection) {
            if (!this.joinpointUpdates.isEmpty()) {
                this.instrumentor.interceptorChainsUpdated(new ArrayList(this.joinpointUpdates), this.hotSwapper);
                this.joinpointUpdates.clear();
            }
        }
    }

    public JoinpointClassifier getJoinpointClassifier() {
        return new JoinpointFullClassifier();
    }

    public DynamicTransformationObserver getDynamicTransformationObserver(CtClass clazz) {
        return new DynamicTransformationTracker(clazz);
    }

    public InterceptorChainObserver getInterceptorChainObserver(Class clazz) {
        ClassPool classPool = AspectManager.instance().findClassPool(clazz.getClassLoader());
        CtClass ctClass = null;
        try {
            ctClass = classPool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Class " + clazz.getName() + " was not found at class pool.");
        }
        return new JoinpointStatusUpdater(ctClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void newJoinpointUpdate(JoinpointStatusUpdate update) {
        Collection collection = this.joinpointUpdates;
        synchronized (collection) {
            this.joinpointUpdates.add(update);
        }
    }

    private class JoinpointStatusUpdater
    implements InterceptorChainObserver {
        private JoinpointStatusUpdate.ClassJoinpoints newlyAdvised;
        private JoinpointStatusUpdate.ClassJoinpoints newlyUnadvised;
        private int instanceInterceptors;
        private WeakHashMap instanceAdvisors;
        private CtClass clazz;
        private int fields;
        private int constructors;
        private int methods;
        private Interceptor[][] fieldReadInterceptors;
        private Interceptor[][] fieldWriteInterceptors;
        private Interceptor[][] constructorInterceptors;
        private MethodInterceptors methodInterceptors;
        private int[] constructorIndexMap;

        public JoinpointStatusUpdater(CtClass clazz) {
            this.clazz = clazz;
            this.instanceAdvisors = new WeakHashMap();
        }

        public synchronized void initialInterceptorChains(final Class reflectionClass, Interceptor[][] fieldReadInterceptors, Interceptor[][] fieldWriteInterceptors, Interceptor[][] constructorInterceptors, MethodInterceptors methodInterceptors) {
            Constructor<?>[] declaredConstructors = null;
            if (System.getSecurityManager() == null) {
                declaredConstructors = reflectionClass.getDeclaredConstructors();
            } else {
                try {
                    declaredConstructors = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor[]>(){

                        @Override
                        public Constructor[] run() throws Exception {
                            return reflectionClass.getDeclaredConstructors();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Error retrieving declared constructors of " + reflectionClass.getName(), e.getException());
                }
            }
            this.constructorIndexMap = new int[declaredConstructors.length];
            int javassistIndex = 0;
            for (int reflectionIndex = 0; reflectionIndex < declaredConstructors.length; ++reflectionIndex) {
                Class<?>[] params = declaredConstructors[reflectionIndex].getParameterTypes();
                this.constructorIndexMap[reflectionIndex] = params.length > 0 && params[params.length - 1].getName().equals("javassist.runtime.Inner") ? -1 : javassistIndex++;
            }
            this.fieldReadInterceptors = fieldReadInterceptors;
            this.fieldWriteInterceptors = fieldWriteInterceptors;
            this.constructorInterceptors = constructorInterceptors;
            this.methodInterceptors = methodInterceptors;
            this.fields = fieldReadInterceptors.length;
            this.constructors = constructorInterceptors.length;
            this.methods = methodInterceptors.size();
            this.newlyAdvised = new JoinpointStatusUpdate.ClassJoinpoints(this.fields, this.constructors, this.methods);
            this.newlyUnadvised = new JoinpointStatusUpdate.ClassJoinpoints(this.fields, this.constructors, this.methods);
        }

        public synchronized void interceptorChainsUpdated(Interceptor[][] newFieldReadInterceptors, Interceptor[][] newFieldWriteInterceptors, Interceptor[][] newConstructorInterceptors, MethodInterceptors newMethodInterceptors) {
            if (this.instanceInterceptors == 0) {
                long[] methodKeys = this.methodInterceptors.keys();
                for (int i = 0; i < methodKeys.length; ++i) {
                    long key = methodKeys[i];
                    MethodInfo oldMethodInfo = this.methodInterceptors.getMethodInfo(key);
                    MethodInfo newMethodInfo = newMethodInterceptors.getMethodInfo(key);
                    if (oldMethodInfo.getInterceptorChain().isEmpty() && !newMethodInfo.getInterceptorChain().isEmpty()) {
                        this.newlyAdvised.methodExecutions.add(newMethodInfo);
                        continue;
                    }
                    if (oldMethodInfo.getInterceptorChain().isEmpty() || !newMethodInfo.getInterceptorChain().isEmpty()) continue;
                    this.newlyUnadvised.methodExecutions.add(newMethodInfo);
                }
                this.fillNewStateCollections(this.fieldReadInterceptors, newFieldReadInterceptors, this.newlyAdvised.fieldReads, this.newlyUnadvised.fieldReads, null);
                this.fillNewStateCollections(this.fieldWriteInterceptors, newFieldWriteInterceptors, this.newlyAdvised.fieldWrites, this.newlyUnadvised.fieldWrites, null);
                this.fillNewStateCollections(this.constructorInterceptors, newConstructorInterceptors, this.newlyAdvised.constructorExecutions, this.newlyUnadvised.constructorExecutions, this.constructorIndexMap);
                HotSwapStrategy.this.newJoinpointUpdate(this.getJoinpointStatusUpdate());
            }
            this.fieldReadInterceptors = newFieldReadInterceptors;
            this.fieldWriteInterceptors = newFieldWriteInterceptors;
            this.constructorInterceptors = newConstructorInterceptors;
            this.methodInterceptors = newMethodInterceptors;
        }

        public synchronized void instanceInterceptorAdded(InstanceAdvisor instanceAdvisor) {
            this.instanceInterceptorsAdded(instanceAdvisor, 1);
        }

        public synchronized void instanceInterceptorsAdded(InstanceAdvisor instanceAdvisor, int howMany) {
            this.updateInstanceInterceptorsTable(instanceAdvisor, howMany);
            this.updateAdvisenessStatus(this.newlyAdvised);
            this.instanceInterceptors += howMany;
            HotSwapStrategy.this.interceptorChainsUpdated();
        }

        public synchronized void instanceInterceptorRemoved(InstanceAdvisor instanceAdvisor) {
            this.instanceInterceptorsRemoved(instanceAdvisor, 1);
        }

        public synchronized void instanceInterceptorsRemoved(InstanceAdvisor instanceAdvisor, int howMany) {
            this.updateInstanceInterceptorsTable(instanceAdvisor, -howMany);
            this.instanceInterceptors -= howMany;
            this.updateAdvisenessStatus(this.newlyUnadvised);
            HotSwapStrategy.this.interceptorChainsUpdated();
        }

        public synchronized void allInstanceInterceptorsRemoved(InstanceAdvisor instanceAdvisor) {
            if (this.instanceAdvisors.containsKey(instanceAdvisor)) {
                this.instanceAdvisors.remove(instanceAdvisor);
            }
            if (this.instanceInterceptors == 0) {
                return;
            }
            this.instanceInterceptors = 0;
            for (Integer interceptors : this.instanceAdvisors.values()) {
                this.instanceInterceptors += interceptors.intValue();
            }
            if (this.instanceInterceptors > 0) {
                return;
            }
            this.updateAdvisenessStatus(this.newlyUnadvised);
            HotSwapStrategy.this.interceptorChainsUpdated();
        }

        private JoinpointStatusUpdate getJoinpointStatusUpdate() {
            JoinpointStatusUpdate update = new JoinpointStatusUpdate();
            update.clazz = this.clazz;
            update.newlyAdvisedJoinpoints = this.newlyAdvised;
            update.newlyUnadvisedJoinpoints = this.newlyUnadvised;
            this.newlyAdvised = new JoinpointStatusUpdate.ClassJoinpoints(this.fields, this.constructors, this.methods);
            this.newlyUnadvised = new JoinpointStatusUpdate.ClassJoinpoints(this.fields, this.constructors, this.methods);
            return update;
        }

        private void fillNewStateCollections(Interceptor[][] interceptors, Interceptor[][] newInterceptors, Collection newlyAdvised, Collection newlyUnadvised, int[] indexMap) {
            if (this.instanceInterceptors > 0) {
                return;
            }
            for (int i = 0; i < interceptors.length; ++i) {
                boolean interceptedNow;
                Interceptor[] oldInterceptorsChain = interceptors[i];
                Interceptor[] newInterceptorsChain = newInterceptors[i];
                boolean interceptedBefore = oldInterceptorsChain != null && oldInterceptorsChain.length > 0;
                boolean bl = interceptedNow = newInterceptorsChain != null && newInterceptorsChain.length > 0;
                if (!interceptedBefore && interceptedNow) {
                    if (indexMap != null) {
                        if (indexMap[i] == -1) continue;
                        newlyAdvised.add(new Integer(indexMap[i]));
                        continue;
                    }
                    newlyAdvised.add(new Integer(i));
                    continue;
                }
                if (!interceptedBefore || interceptedNow) continue;
                if (indexMap != null) {
                    if (indexMap[i] == -1) continue;
                    newlyUnadvised.add(new Integer(indexMap[i]));
                    continue;
                }
                newlyUnadvised.add(new Integer(i));
            }
        }

        private void updateInstanceInterceptorsTable(InstanceAdvisor instanceAdvisor, int interceptorsAdded) {
            if (this.instanceAdvisors.containsKey(instanceAdvisor)) {
                Integer interceptors = (Integer)this.instanceAdvisors.get(instanceAdvisor);
                this.instanceAdvisors.put(instanceAdvisor, new Integer(interceptors + interceptorsAdded));
            } else {
                this.instanceAdvisors.put(instanceAdvisor, new Integer(interceptorsAdded));
            }
        }

        private void updateAdvisenessStatus(JoinpointStatusUpdate.ClassJoinpoints joinpoints) {
            if (this.instanceInterceptors == 0) {
                long[] methodKeys = this.methodInterceptors.keys();
                for (int i = 0; i < methodKeys.length; ++i) {
                    long key = methodKeys[i];
                    MethodInfo methodInfo = this.methodInterceptors.getMethodInfo(key);
                    if (!methodInfo.getInterceptorChain().isEmpty()) continue;
                    joinpoints.methodExecutions.add(methodInfo);
                }
                this.findUnadvisedJoinpoints(this.fieldReadInterceptors, joinpoints.fieldReads);
                this.findUnadvisedJoinpoints(this.fieldWriteInterceptors, joinpoints.fieldWrites);
                this.findUnadvisedJoinpoints(this.constructorInterceptors, joinpoints.constructorExecutions);
                HotSwapStrategy.this.newJoinpointUpdate(this.getJoinpointStatusUpdate());
            }
        }

        private void findUnadvisedJoinpoints(Interceptor[][] interceptors, Collection joinpointsFound) {
            for (int i = 0; i < interceptors.length; ++i) {
                if (interceptors[i] != null && interceptors[i].length != 0) continue;
                joinpointsFound.add(new Integer(i));
            }
        }
    }

    private class DynamicTransformationTracker
    implements DynamicTransformationObserver {
        private CtClass clazz;
        private Collection fieldReads;
        private Collection fieldWrites;
        private boolean constructor;

        public DynamicTransformationTracker(CtClass clazz) {
            this.clazz = clazz;
            this.fieldReads = new ArrayList();
            this.fieldWrites = new ArrayList();
            this.constructor = false;
        }

        public void fieldReadDynamicalyWrapped(CtField field) {
            this.fieldReads.add(field);
        }

        public void fieldWriteDynamicalyWrapped(CtField field) {
            this.fieldWrites.add(field);
        }

        public void constructorDynamicalyWrapped() {
            this.constructor = true;
        }

        public void transformationFinished(CtClass clazz, CodeConverter converter) {
            if (this.constructor || !this.fieldReads.isEmpty() || !this.fieldWrites.isEmpty()) {
                HotSwapStrategy.this.instrumentor.convertProcessedClasses(HotSwapStrategy.this.hotSwapper, clazz, this.fieldReads, this.fieldWrites, this.constructor);
            }
        }
    }
}

