/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.reflection;

import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ConByConInfo;
import org.jboss.aop.ConByMethodInfo;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.FieldInfo;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.MethodByMethodInfo;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.util.MethodHashing;

public class ReflectionAspect {
    private static Pattern fieldGetPattern = Pattern.compile("get(|Boolean|Byte|Char|Double|Float|Int|Long|Short)?");
    private static Pattern fieldSetPattern = Pattern.compile("set(|Boolean|Byte|Char|Double|Float|Int|Long|Short)?");
    private static Pattern accessMethodPattern = Pattern.compile("access[$](\\d)+");

    public Object interceptNewInstance(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Method reflectionMethod = invocation.getCalledMethod();
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptNewInstance(invocation, reflectionMethod, targetObject, args);
    }

    public Object interceptNewInstance(MethodCalledByMethodInvocation invocation) throws Throwable {
        Method reflectionMethod = invocation.getCalledMethod();
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptNewInstance(invocation, reflectionMethod, targetObject, args);
    }

    public Object interceptMethodInvoke(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Method reflectionMethod = invocation.getCalledMethod();
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptMethodInvoke(invocation, reflectionMethod, targetObject, args);
    }

    public Object interceptMethodInvoke(MethodCalledByMethodInvocation invocation) throws Throwable {
        Method reflectionMethod = invocation.getCalledMethod();
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptMethodInvoke(invocation, reflectionMethod, targetObject, args);
    }

    public Object interceptFieldSet(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Method reflectionMethod = invocation.getCalledMethod();
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptFieldSet(invocation, reflectionMethod, targetObject, args);
    }

    public Object interceptFieldSet(MethodCalledByMethodInvocation invocation) throws Throwable {
        Method reflectionMethod = invocation.getCalledMethod();
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptFieldSet(invocation, reflectionMethod, targetObject, args);
    }

    public Object interceptFieldGet(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Method reflectionMethod = invocation.getCalledMethod();
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptFieldGet(invocation, reflectionMethod, targetObject, args);
    }

    public Object interceptFieldGet(MethodCalledByMethodInvocation invocation) throws Throwable {
        Method reflectionMethod = invocation.getCalledMethod();
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptFieldGet(invocation, reflectionMethod, targetObject, args);
    }

    public final Object interceptGetDeclaredMethods(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetDeclaredMethods((Class)targetObject);
    }

    public final Object interceptGetDeclaredMethods(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetDeclaredMethods((Class)targetObject);
    }

    public final Object interceptGetDeclaredMethod(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptGetDeclaredMethod((Class)targetObject, args);
    }

    public final Object interceptGetDeclaredMethod(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptGetDeclaredMethod((Class)targetObject, args);
    }

    public final Object interceptGetMethods(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetMethods((Class)targetObject);
    }

    public final Object interceptGetMethods(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetMethods((Class)targetObject);
    }

    public final Object interceptGetMethod(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptGetMethod((Class)targetObject, args);
    }

    public final Object interceptGetMethod(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptGetMethod((Class)targetObject, args);
    }

    public final Object interceptGetInterfaces(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetInterfaces((Class)targetObject);
    }

    public final Object interceptGetInterfaces(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetInterfaces((Class)targetObject);
    }

    public final Object interceptGetDeclaredClasses(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetDeclaredClasses((Class)targetObject);
    }

    public final Object interceptGetDeclaredClasses(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetDeclaredClasses((Class)targetObject);
    }

    public final Object interceptGetClasses(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetClasses((Class)targetObject);
    }

    public final Object interceptGetClasses(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetClasses((Class)targetObject);
    }

    public final Object interceptGetDeclaredFields(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetDeclaredFields((Class)targetObject);
    }

    public final Object interceptGetDeclaredFields(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        return this.interceptGetDeclaredFields((Class)targetObject);
    }

    public final Object interceptGetDeclaredField(MethodCalledByConstructorInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptGetDeclaredField((Class)targetObject, args);
    }

    public final Object interceptGetDeclaredField(MethodCalledByMethodInvocation invocation) throws Throwable {
        Object targetObject = invocation.getTargetObject();
        Object[] args = invocation.getArguments();
        return this.interceptGetDeclaredField((Class)targetObject, args);
    }

    public final Object interceptGetFields(MethodCalledByConstructorInvocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    public final Object interceptGetFields(MethodCalledByMethodInvocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    public final Object interceptGetDeclaredConstructors(MethodCalledByConstructorInvocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    public final Object interceptGetDeclaredConstructors(MethodCalledByMethodInvocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    public final Object interceptGetDeclaredConstructor(MethodCalledByConstructorInvocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    public final Object interceptGetDeclaredConstructor(MethodCalledByMethodInvocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    public final Object interceptGetConstructors(MethodCalledByConstructorInvocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    public final Object interceptGetConstructors(MethodCalledByMethodInvocation invocation) throws Throwable {
        return invocation.invokeNext();
    }

    protected Object interceptConstructor(Invocation invocation, Constructor constructor, Object[] args) throws Throwable {
        return this.invokeOriginalChainIfExists(invocation, constructor, args);
    }

    protected Object interceptFieldRead(Invocation invocation, Field field, Object instance) throws Throwable {
        return this.invokeOriginalChainIfExists(invocation, field, instance);
    }

    protected Object interceptFieldWrite(Invocation invocation, Field field, Object instance, Object arg) throws Throwable {
        return this.invokeOriginalChainIfExists(invocation, field, instance, arg);
    }

    protected Object interceptMethod(Invocation invocation, Method method, Object instance, Object[] args) throws Throwable {
        return this.invokeOriginalChainIfExists(invocation, method, instance, args);
    }

    private Object interceptNewInstance(Invocation invocation, Method reflectionMethod, Object targetObject, Object[] args) throws Throwable {
        Class<?> reflectionClass = targetObject.getClass();
        if (reflectionClass.equals(Class.class)) {
            Constructor constructor = ((Class)targetObject).getConstructor(new Class[0]);
            return this.interceptConstructor(invocation, constructor, args);
        }
        if (reflectionClass.equals(Constructor.class) && reflectionMethod.getName().equals("newInstance")) {
            int length = args.length;
            Object[] constructorArgs = length < 1 ? new Object[]{} : (Object[])args[0];
            Constructor constructor = (Constructor)targetObject;
            return this.interceptConstructor(invocation, constructor, constructorArgs);
        }
        return invocation.invokeNext();
    }

    private Object interceptMethodInvoke(Invocation invocation, Method reflectionMethod, Object targetObject, Object[] args) throws Throwable {
        Method method = (Method)invocation.getTargetObject();
        if (reflectionMethod.getName().equals("invoke")) {
            Object instance = args[0];
            return this.interceptMethod(invocation, method, instance, (Object[])args[1]);
        }
        return invocation.invokeNext();
    }

    private Class[] interceptGetInterfaces(Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        ArrayList cleanedInterfaces = new ArrayList(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals(Advised.class)) continue;
            cleanedInterfaces.add(interfaces[i]);
        }
        return cleanedInterfaces.toArray(new Class[cleanedInterfaces.size()]);
    }

    private Object interceptFieldSet(Invocation invocation, Method reflectionMethod, Object targetObject, Object[] args) throws Throwable {
        Field field = (Field)invocation.getTargetObject();
        Matcher m = fieldSetPattern.matcher(reflectionMethod.getName());
        if (m.matches()) {
            Object instance = args[0];
            return this.interceptFieldWrite(invocation, field, instance, args[1]);
        }
        return invocation.invokeNext();
    }

    private Object interceptFieldGet(Invocation invocation, Method reflectionMethod, Object targetObject, Object[] args) throws Throwable {
        Field field = (Field)invocation.getTargetObject();
        Matcher m = fieldGetPattern.matcher(reflectionMethod.getName());
        if (m.matches()) {
            Object instance = args[0];
            return this.interceptFieldRead(invocation, field, instance);
        }
        return invocation.invokeNext();
    }

    private Method[] interceptGetDeclaredMethods(Class clazz) {
        ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
        if (advisor == null) {
            return ReflectionAspect.getDeclaredMethods(clazz);
        }
        Object[] advisedMethods = advisor.getAdvisedMethods().getValues();
        ArrayList<Method> methods = new ArrayList<Method>(advisedMethods.length);
        for (int i = 0; i < advisedMethods.length; ++i) {
            Method m = (Method)advisedMethods[i];
            if (!clazz.equals(m.getDeclaringClass()) || !this.isNotAccessMethod(m) || !this.isNotJavassistWrappedMethod(m)) continue;
            methods.add(m);
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private Method interceptGetDeclaredMethod(Class clazz, Object[] args) throws NoSuchMethodException {
        ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
        Method method = ReflectionAspect.getDeclaredMethod(clazz, (String)args[0], (Class[])args[1]);
        if (advisor == null) {
            return method;
        }
        Object[] advisedMethods = advisor.getAdvisedMethods().getValues();
        for (int i = 0; i < advisedMethods.length; ++i) {
            Method m = (Method)advisedMethods[i];
            if (!m.equals(method) || !this.isNotAccessMethod(m) || !this.isNotJavassistWrappedMethod(m)) continue;
            return method;
        }
        throw new NoSuchMethodException();
    }

    private boolean isNotAccessMethod(Method m) {
        Matcher match;
        return !Modifier.isStatic(m.getModifiers()) || !(match = accessMethodPattern.matcher(m.getName())).matches();
    }

    private boolean isNotJavassistWrappedMethod(Method m) {
        return !Modifier.isPrivate(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || !m.getName().startsWith("_added_m$");
    }

    private Method[] interceptGetMethods(Class clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        GetMethodsAlreadyFound methodsFound = new GetMethodsAlreadyFound();
        while (clazz != null) {
            ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
            Object[] foundMethods = advisor == null ? ReflectionAspect.getDeclaredMethods(clazz) : advisor.getAdvisedMethods().getValues();
            for (int i = 0; i < foundMethods.length; ++i) {
                Method m = (Method)foundMethods[i];
                if (!clazz.equals(m.getDeclaringClass()) || !Modifier.isPublic(m.getModifiers()) || methodsFound.existsMethod(m)) continue;
                methods.add(m);
                methodsFound.addMethod(m);
            }
            clazz = clazz.getSuperclass();
        }
        return methods.toArray(new Method[methods.size()]);
    }

    private Method interceptGetMethod(Class clazz, Object[] args) throws NoSuchMethodException {
        Method method = clazz.getMethod((String)args[0], (Class[])args[1]);
        Class<?> declaringClass = method.getDeclaringClass();
        while (clazz != null) {
            if (clazz.equals(declaringClass)) {
                ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
                if (advisor == null) {
                    return method;
                }
                Object[] methods = advisor.getAdvisedMethods().getValues();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = (Method)methods[i];
                    if (!m.equals(method)) continue;
                    return method;
                }
            }
            clazz = clazz.getSuperclass();
        }
        throw new NoSuchMethodException();
    }

    private Field[] interceptGetDeclaredFields(Class clazz) {
        ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
        if (advisor == null) {
            return ReflectionAspect.getDeclaredFields(clazz);
        }
        Field[] advisedFields = advisor.getAdvisedFields();
        ArrayList<Field> fields = new ArrayList<Field>(advisedFields.length);
        for (int i = 0; i < advisedFields.length; ++i) {
            Field f = advisedFields[i];
            if (!clazz.equals(f.getDeclaringClass())) continue;
            fields.add(f);
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private Class[] interceptGetClasses(Class clazz) throws Throwable {
        Class[] classes = clazz.getClasses();
        return this.cleanClasses(classes);
    }

    private Class[] interceptGetDeclaredClasses(Class clazz) throws Throwable {
        Class[] classes = ReflectionAspect.getDeclaredClasses(clazz);
        return this.cleanClasses(classes);
    }

    private Class[] cleanClasses(Class[] classes) {
        ArrayList<Class> clazzes = new ArrayList<Class>();
        for (int i = 0; i < classes.length; ++i) {
            Class innerClass = classes[i];
            Class<?>[] interfaces = classes[i].getInterfaces();
            boolean implUntransformable = false;
            for (int j = 0; j < interfaces.length; ++j) {
                if (!interfaces[j].equals(Untransformable.class)) continue;
                implUntransformable = true;
                break;
            }
            if (implUntransformable) continue;
            boolean isInvocationImpl = false;
            block2: for (Class superclass = innerClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                interfaces = classes[i].getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    if (!interfaces[j].equals(Invocation.class)) continue;
                    isInvocationImpl = true;
                    continue block2;
                }
            }
            if (isInvocationImpl) continue;
            clazzes.add(innerClass);
        }
        return clazzes.toArray(new Class[clazzes.size()]);
    }

    private Field interceptGetDeclaredField(Class clazz, Object[] args) throws NoSuchFieldException {
        ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
        Field field = ReflectionAspect.getDeclaredField(clazz, (String)args[0]);
        if (advisor == null) {
            return field;
        }
        Field[] advisedFields = advisor.getAdvisedFields();
        for (int i = 0; i < advisedFields.length; ++i) {
            Field f = advisedFields[i];
            if (!f.equals(field)) continue;
            return field;
        }
        throw new NoSuchFieldException();
    }

    private Object invokeOriginalChainIfExists(Invocation invocation, Constructor constructor, Object[] args) throws Throwable {
        int index;
        ClassAdvisor advisor;
        Class calledClass;
        ClassAdvisor advisor2;
        Method callingMethod;
        CallerInvocation inv;
        if (invocation instanceof MethodCalledByConstructorInvocation) {
            long calledHash;
            ConByConInfo info;
            TLongObjectHashMap calledCons;
            HashMap calledClassesMap;
            int index2;
            ClassAdvisor advisor3;
            inv = (MethodCalledByConstructorInvocation)invocation;
            Constructor callingCon = ((MethodCalledByConstructorInvocation)inv).getCalling();
            Class callingClass = callingCon.getDeclaringClass();
            if (this.isAdvised(callingClass) && (advisor3 = AspectManager.instance().getAdvisor(callingClass)) != null && (index2 = advisor3.getConstructorIndex(callingCon)) >= 0 && (calledClassesMap = advisor3.getConCalledByConInterceptors()[index2]) != null && (calledCons = (TLongObjectHashMap)calledClassesMap.get(constructor.getDeclaringClass().getName())) != null && (info = (ConByConInfo)calledCons.get(calledHash = MethodHashing.constructorHash(constructor))) != null && info.hasAdvices()) {
                return advisor3.invokeConCalledByCon(info, inv.getCallingObject(), args);
            }
        } else if (invocation instanceof MethodCalledByMethodInvocation && this.isAdvised((callingMethod = ((MethodCalledByMethodInvocation)(inv = (MethodCalledByMethodInvocation)invocation)).getCallingMethod()).getDeclaringClass()) && (advisor2 = AspectManager.instance().getAdvisor(callingMethod.getDeclaringClass())) != null) {
            ConByMethodInfo info;
            TLongObjectHashMap calledCons;
            long callingMethodHash = MethodHashing.calculateHash(callingMethod);
            long calledHash = MethodHashing.constructorHash(constructor);
            HashMap calledClassesMap = (HashMap)advisor2.getConCalledByMethodInterceptors().get(callingMethodHash);
            if (calledClassesMap != null && (calledCons = (TLongObjectHashMap)calledClassesMap.get(constructor.getDeclaringClass().getName())) != null && (info = (ConByMethodInfo)calledCons.get(calledHash)) != null && info.hasAdvices()) {
                return advisor2.invokeConCalledByMethod(info, inv.getCallingObject(), args);
            }
        }
        if (this.isAdvised(calledClass = constructor.getDeclaringClass()) && (advisor = AspectManager.instance().getAdvisor(constructor.getDeclaringClass())) != null && advisor.hasAspects() && (index = advisor.getConstructorIndex(constructor)) >= 0) {
            ConstructorInfo jp = advisor.getConstructorInfos()[index];
            return jp.getWrapper().invoke(null, args);
        }
        return invocation.invokeNext();
    }

    private Object invokeOriginalChainIfExists(Invocation invocation, Field field, Object targetObject) throws Throwable {
        int index;
        ClassAdvisor advisor = AspectManager.instance().getAdvisor(field.getDeclaringClass());
        Class<?> calledClass = field.getDeclaringClass();
        if (this.isAdvised(calledClass) && advisor != null && advisor.hasAspects() && (index = advisor.getFieldIndex(field)) >= 0) {
            FieldInfo jp = advisor.getFieldReadInfos()[index];
            return jp.getWrapper().invoke(null, targetObject);
        }
        return invocation.invokeNext();
    }

    private Object invokeOriginalChainIfExists(Invocation invocation, Field field, Object targetObject, Object value) throws Throwable {
        int index;
        ClassAdvisor advisor = AspectManager.instance().getAdvisor(field.getDeclaringClass());
        Class<?> calledClass = field.getDeclaringClass();
        if (this.isAdvised(calledClass) && advisor != null && advisor.hasAspects() && (index = advisor.getFieldIndex(field)) >= 0) {
            FieldInfo jp = advisor.getFieldWriteInfos()[index];
            return jp.getWrapper().invoke(null, targetObject, value);
        }
        return invocation.invokeNext();
    }

    private Object invokeOriginalChainIfExists(Invocation invocation, Method method, Object targetObject, Object[] args) throws Throwable {
        ClassAdvisor advisor;
        MethodCalledByMethodInvocation inv;
        Method callingMethod;
        if (invocation instanceof MethodCalledByConstructorInvocation) {
            long calledHash;
            MethodByConInfo info;
            TLongObjectHashMap calledMethods;
            HashMap calledClassesMap;
            int index;
            ClassAdvisor advisor2;
            MethodCalledByConstructorInvocation inv2 = (MethodCalledByConstructorInvocation)invocation;
            Constructor callingCon = inv2.getCalling();
            Class callingClass = callingCon.getDeclaringClass();
            if (this.isAdvised(callingClass) && (advisor2 = AspectManager.instance().getAdvisor(callingClass)) != null && (index = advisor2.getConstructorIndex(callingCon)) >= 0 && (calledClassesMap = advisor2.getMethodCalledByConInterceptors()[index]) != null && (calledMethods = (TLongObjectHashMap)calledClassesMap.get(method.getDeclaringClass().getName())) != null && (info = (MethodByConInfo)calledMethods.get(calledHash = MethodHashing.calculateHash(method))) != null && info.hasAdvices()) {
                return advisor2.invokeConstructorCaller(info, inv2.getCallingObject(), targetObject, args);
            }
        } else if (invocation instanceof MethodCalledByMethodInvocation && this.isAdvised((callingMethod = (inv = (MethodCalledByMethodInvocation)invocation).getCallingMethod()).getDeclaringClass()) && (advisor = AspectManager.instance().getAdvisor(callingMethod.getDeclaringClass())) != null) {
            MethodByMethodInfo info;
            TLongObjectHashMap calledMethods;
            long callingMethodHash = MethodHashing.calculateHash(callingMethod);
            long calledHash = MethodHashing.calculateHash(method);
            HashMap calledClassesMap = (HashMap)advisor.getMethodCalledByMethodInterceptors().get(callingMethodHash);
            if (calledClassesMap != null && (calledMethods = (TLongObjectHashMap)calledClassesMap.get(method.getDeclaringClass().getName())) != null && (info = (MethodByMethodInfo)calledMethods.get(calledHash)) != null && info.hasAdvices()) {
                return advisor.invokeCaller(info, inv.getCallingObject(), targetObject, args);
            }
        }
        return invocation.invokeNext();
    }

    private boolean isAdvised(Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(Advised.class)) continue;
            return true;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            return this.isAdvised(superClass);
        }
        return false;
    }

    private static Method[] getDeclaredMethods(Class clazz) {
        if (System.getSecurityManager() == null) {
            return SecurityAction.NON_PRIVILEGED.getDeclaredMethods(clazz);
        }
        return SecurityAction.PRIVILEGED.getDeclaredMethods(clazz);
    }

    private static Field[] getDeclaredFields(Class clazz) {
        if (System.getSecurityManager() == null) {
            return SecurityAction.NON_PRIVILEGED.getDeclaredFields(clazz);
        }
        return SecurityAction.PRIVILEGED.getDeclaredFields(clazz);
    }

    private static Class[] getDeclaredClasses(Class clazz) {
        if (System.getSecurityManager() == null) {
            return SecurityAction.NON_PRIVILEGED.getDeclaredClasses(clazz);
        }
        return SecurityAction.PRIVILEGED.getDeclaredClasses(clazz);
    }

    private static Field getDeclaredField(Class clazz, String name) throws NoSuchFieldException {
        if (System.getSecurityManager() == null) {
            return SecurityAction.NON_PRIVILEGED.getDeclaredField(clazz, name);
        }
        return SecurityAction.PRIVILEGED.getDeclaredField(clazz, name);
    }

    private static Method getDeclaredMethod(Class clazz, String name, Class[] paramTypes) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return SecurityAction.NON_PRIVILEGED.getDeclaredMethod(clazz, name, paramTypes);
        }
        return SecurityAction.PRIVILEGED.getDeclaredMethod(clazz, name, paramTypes);
    }

    private static interface SecurityAction {
        public static final SecurityAction NON_PRIVILEGED = new SecurityAction(){

            public Field[] getDeclaredFields(Class clazz) {
                return clazz.getDeclaredFields();
            }

            public Method[] getDeclaredMethods(Class clazz) {
                return clazz.getDeclaredMethods();
            }

            public Class[] getDeclaredClasses(Class clazz) {
                return clazz.getDeclaredClasses();
            }

            public Field getDeclaredField(Class clazz, String name) throws NoSuchFieldException {
                return clazz.getDeclaredField(name);
            }

            public Method getDeclaredMethod(Class clazz, String name, Class[] paramTypes) throws NoSuchMethodException {
                return clazz.getDeclaredMethod(name, paramTypes);
            }
        };
        public static final SecurityAction PRIVILEGED = new SecurityAction(){

            public Field[] getDeclaredFields(final Class clazz) {
                return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz.getDeclaredFields();
                    }
                });
            }

            public Method[] getDeclaredMethods(final Class clazz) {
                return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz.getDeclaredMethods();
                    }
                });
            }

            public Class[] getDeclaredClasses(final Class clazz) {
                return (Class[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz.getDeclaredClasses();
                    }
                });
            }

            public Field getDeclaredField(final Class clazz, final String name) throws NoSuchFieldException {
                try {
                    return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return clazz.getDeclaredField(name);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof NoSuchFieldException) {
                        throw (NoSuchFieldException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }

            public Method getDeclaredMethod(final Class clazz, final String name, final Class[] paramTypes) throws NoSuchMethodException {
                try {
                    return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return clazz.getDeclaredMethod(name, paramTypes);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof NoSuchMethodException) {
                        throw (NoSuchMethodException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };

        public Method[] getDeclaredMethods(Class var1);

        public Field[] getDeclaredFields(Class var1);

        public Class[] getDeclaredClasses(Class var1);

        public Field getDeclaredField(Class var1, String var2) throws NoSuchFieldException;

        public Method getDeclaredMethod(Class var1, String var2, Class[] var3) throws NoSuchMethodException;
    }

    class GetMethodsAlreadyFound {
        HashMap methodMap = new HashMap();

        GetMethodsAlreadyFound() {
        }

        public void addMethod(Method m) {
            String methodName = m.getName();
            ArrayList<Method> methods = (ArrayList<Method>)this.methodMap.get(methodName);
            if (methods == null) {
                methods = new ArrayList<Method>();
                this.methodMap.put(methodName, methods);
            }
            methods.add(m);
        }

        public boolean existsMethod(Method method) {
            ArrayList methods = (ArrayList)this.methodMap.get(method.getName());
            if (methods == null) {
                return false;
            }
            Class<?>[] methodParamTypes = method.getParameterTypes();
            for (Method found : methods) {
                Class<?>[] foundParamTypes = found.getParameterTypes();
                if (methodParamTypes.length != foundParamTypes.length) continue;
                boolean same = true;
                for (int i = 0; i < methodParamTypes.length; ++i) {
                    if (methodParamTypes[i].equals(foundParamTypes[i])) continue;
                    same = false;
                }
                if (!same) continue;
                return true;
            }
            return false;
        }
    }
}

