/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class AopC
extends MatchingTask {
    static final String SYS_OPTIMIZED = "jboss.aop.optimized";
    static final String SYS_INSTRUMENTOR = "jboss.aop.instrumentor";
    private static String lSep = System.getProperty("line.separator");
    private int maxSrc = 1000;
    private String instrumentor;
    private String jvm;
    private Path classpath;
    private Path aoppath;
    private Path aopclasspath;
    private Path compilerClasspath;
    private Path compileSourcepath;
    private boolean verbose = false;
    private boolean suppress = true;
    private boolean report = false;
    private boolean optimized = true;
    private String maxmemory = null;
    ArrayList<Environment.Variable> sysproperties = new ArrayList();
    File sourceFiles;
    protected boolean failOnError = true;

    public void setVerbose(boolean i) {
        this.verbose = i;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public String getInstrumentor() {
        return this.instrumentor;
    }

    public void setInstrumentor(String instrumentor) {
        this.instrumentor = instrumentor;
    }

    public void setSuppress(boolean i) {
        this.suppress = i;
    }

    public boolean getSupress() {
        return this.suppress;
    }

    public void setReport(boolean i) {
        this.report = i;
    }

    public boolean getReport() {
        return this.report;
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public boolean getOptimized() {
        return this.optimized;
    }

    public void setMaxmemory(String maxmemory) {
        this.maxmemory = maxmemory;
    }

    public String getMaxmemory() {
        return this.maxmemory;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setClasspath(Path cp) {
        if (this.classpath == null) {
            this.classpath = cp;
        } else {
            this.classpath.append(cp);
        }
    }

    public void setMaxSrc(int maxSrc) {
        this.maxSrc = maxSrc;
    }

    public int getMaxSrc() {
        return this.maxSrc;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setCompilerClasspathRef(Reference r) {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = new Path(this.getProject());
        }
        this.compilerClasspath.setRefid(r);
    }

    public void setCompilerclasspath(Path cp) {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = cp;
        } else {
            this.compilerClasspath.append(cp);
        }
    }

    public Path getCompilerclasspath() {
        return this.compilerClasspath;
    }

    public Path createCompilerclasspath() {
        if (this.compilerClasspath == null) {
            this.compilerClasspath = new Path(this.getProject());
        }
        return this.compilerClasspath.createPath();
    }

    public Path createSrc() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public Path createAoppath() {
        if (this.aoppath == null) {
            this.aoppath = new Path(this.getProject());
        }
        Path path = this.aoppath.createPath();
        return path;
    }

    public Path createAopclasspath() {
        if (this.aopclasspath == null) {
            this.aopclasspath = new Path(this.getProject());
        }
        return this.aopclasspath.createPath();
    }

    public void addSysproperty(Environment.Variable property) {
        this.sysproperties.add(property);
    }

    public void execute() throws BuildException {
        CommandlineJava cmd = new CommandlineJava();
        if (this.verbose) {
            cmd.createArgument().setValue("-verbose");
        }
        if (this.suppress) {
            cmd.createArgument().setValue("-suppress");
        }
        if (!this.optimized) {
            cmd.createArgument().setValue("-noopt");
        }
        if (this.report) {
            cmd.createArgument().setValue("-report");
        }
        if (this.aoppath != null && this.aoppath.size() > 0) {
            cmd.createArgument().setValue("-aoppath");
            cmd.createArgument().setValue(this.aoppath.toString());
        }
        if (this.aopclasspath != null && this.aopclasspath.size() > 0) {
            cmd.createArgument().setValue("-aopclasspath");
            cmd.createArgument().setValue(this.aopclasspath.toString());
        }
        this.logAndAddFilesToCompile(cmd);
        try {
            this.classpath.append(this.compilerClasspath);
            Java java = (Java)this.getProject().createTask("java");
            if (this.jvm != null && this.jvm.length() > 0) {
                java.setJvm(this.jvm);
            }
            if (this.getClasspath() != null) {
                this.getProject().log("using user supplied classpath: " + this.getClasspath(), 4);
                java.setClasspath(this.getClasspath().concatSystemClasspath("ignore"));
            } else {
                Path classpath = new Path(this.getProject());
                classpath = classpath.concatSystemClasspath("only");
                this.getProject().log("using system classpath: " + classpath, 4);
                java.setClasspath(classpath);
            }
            java.setDir(this.getProject().getBaseDir());
            java.setClassname("org.jboss.aop.standalone.Compiler");
            String[] args = cmd.getJavaCommand().getArguments();
            for (int i = 0; i < args.length; ++i) {
                java.createArg().setValue(args[i]);
            }
            java.setFailonerror(this.getFailonerror());
            java.setFork(true);
            java.setTaskName("aopc");
            Environment.Variable optimize = new Environment.Variable();
            optimize.setKey(SYS_OPTIMIZED);
            optimize.setValue(String.valueOf(this.optimized));
            java.addSysproperty(optimize);
            for (Environment.Variable var : this.sysproperties) {
                java.addSysproperty(var);
            }
            if (this.maxmemory != null) {
                java.setMaxmemory(this.maxmemory);
            }
            java.execute();
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Error running aopc compiler: ", (Throwable)ex, this.getLocation());
        }
        finally {
            if (this.sourceFiles != null) {
                this.sourceFiles.delete();
            }
        }
    }

    protected void logAndAddFilesToCompile(CommandlineJava cmd) {
        String[] list = this.compileSourcepath.list();
        ArrayList<String> compilingFiles = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].endsWith(".class")) continue;
                File f = new File(srcDir, files[j]);
                compilingFiles.add(f.getAbsolutePath());
            }
        }
        int length = 0;
        for (int i = 0; i < compilingFiles.size() && (length += ((String)compilingFiles.get(i)).length() + 1) <= this.maxSrc; ++i) {
        }
        if (length < this.maxSrc) {
            StringBuffer niceSourceList = new StringBuffer("Files\n");
            for (int i = 0; i < compilingFiles.size(); ++i) {
                String file = (String)compilingFiles.get(i);
                cmd.createArgument().setValue(file);
                niceSourceList.append("    " + file + lSep);
            }
        } else {
            for (Environment.Variable var : this.sysproperties) {
                if (!var.getKey().equals("java.io.tmpdir")) continue;
                System.setProperty("java.io.tmpdir", var.getValue());
            }
            BufferedWriter writer = null;
            try {
                this.sourceFiles = File.createTempFile("src", ".tmp");
                if (this.verbose) {
                    System.out.println("[info] Total length of filenames to be compiled is greater than " + this.maxSrc + ", listing files in --SOURCEPATH: " + this.sourceFiles.getAbsolutePath());
                }
                this.sourceFiles.deleteOnExit();
                writer = new BufferedWriter(new FileWriter(this.sourceFiles));
                for (int i = 0; i < compilingFiles.size(); ++i) {
                    writer.write((String)compilingFiles.get(i));
                    writer.newLine();
                }
                writer.flush();
                cmd.createArgument().setValue("--SOURCEPATH");
                cmd.createArgument().setValue(this.sourceFiles.getAbsolutePath());
            }
            catch (IOException e) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw new RuntimeException(e);
            }
        }
    }
}

