/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.classpool.AOPClassLoaderScopingPolicy;
import org.jboss.aop.classpool.AOPClassPoolRepository;
import org.jboss.aop.classpool.AOPScopedClassLoaderHelper;
import org.jboss.logging.Logger;

public class AOPScopedClassLoaderHelperBridge
implements AOPClassLoaderScopingPolicy {
    private static final Logger log = Logger.getLogger(AOPScopedClassLoaderHelper.class);
    private AOPScopedClassLoaderHelper delegate;
    private Map<Object, Domain> scopedClassLoaderDomains = new WeakHashMap<Object, Domain>();

    public AOPScopedClassLoaderHelperBridge(AOPScopedClassLoaderHelper delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    public boolean isScoped(ClassLoader classLoader) {
        return this.delegate.ifScopedDeploymentGetScopedParentUclForCL(classLoader) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Domain getDomain(ClassLoader classLoader, AspectManager parent) {
        ClassLoader scopedClassLoader = this.delegate.ifScopedDeploymentGetScopedParentUclForCL(classLoader);
        if (scopedClassLoader != null) {
            Domain scopedManager = null;
            Map map = AOPClassPoolRepository.getInstance().getRegisteredCLs();
            synchronized (map) {
                Object loaderRepository = this.delegate.getLoaderRepository(classLoader);
                scopedManager = this.scopedClassLoaderDomains.get(loaderRepository);
                if (scopedManager != null && !scopedManager.isValid()) {
                    this.scopedClassLoaderDomains.remove(loaderRepository);
                    scopedManager = null;
                }
                if (scopedManager == null) {
                    scopedManager = this.delegate.getScopedClassLoaderDomain(scopedClassLoader, parent);
                    log.debug((Object)("Created domain " + scopedManager + " for scoped deployment on: " + classLoader + "; identifying scoped ucl: " + scopedClassLoader));
                    scopedManager.setInheritsBindings(true);
                    scopedManager.setInheritsDeclarations(true);
                    this.scopedClassLoaderDomains.put(loaderRepository, scopedManager);
                }
                return scopedManager;
            }
        }
        return null;
    }

    public Domain getTopLevelDomain(AspectManager parent) {
        ClassLoader classLoader = this.delegate.getTopLevelJBossClassLoader();
        return this.getDomain(classLoader, parent);
    }
}

