/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopeUtil;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.microcontainer.beans.GenericBeanAspectFactory;
import org.jboss.aop.microcontainer.beans.ManagedAspectDefinition;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.dependency.spi.Controller;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public class Aspect
implements KernelControllerContextAware,
Untransformable {
    private static final Logger log = Logger.getLogger(Aspect.class);
    protected AspectManager manager;
    protected String adviceName = GUID.asString();
    protected String adviceBean;
    protected String scope;
    protected ManagedAspectDefinition definition;
    protected GenericBeanFactory advice;
    protected Controller controller;
    protected String myname;
    protected String aspectDefName;
    protected Kernel kernel;

    public String getAdviceName() {
        return this.adviceName;
    }

    public void setAdviceName(String adviceName) {
        this.adviceName = adviceName;
    }

    public String getAdviceBean() {
        return this.adviceBean;
    }

    public void setAdviceBean(String adviceBean) {
        this.adviceBean = adviceBean;
    }

    public AspectDefinition getDefinition() {
        return this.definition;
    }

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public GenericBeanFactory getAdvice() {
        return this.advice;
    }

    public void setAdvice(GenericBeanFactory advice) {
        this.advice = advice;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.myname = (String)context.getName();
        this.controller = context.getController();
        this.kernel = context.getKernel();
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.controller = null;
    }

    public void install(GenericBeanFactory factory) throws Exception {
        this.advice = factory;
        this.start();
    }

    public void start() throws Exception {
        if (this.definition == null) {
            String string = this.aspectDefName = this.adviceBean != null ? this.adviceBean : this.myname;
            if (this.manager == null) {
                throw new IllegalArgumentException("Null manager");
            }
            Scope theScope = ScopeUtil.parse((String)this.scope);
            this.definition = this.advice != null ? new ManagedAspectDefinition(this.aspectDefName, theScope, new GenericBeanAspectFactory(this.adviceName, this.advice)) : (this.adviceBean != null && this.controller != null ? new ManagedAspectDefinition(this.aspectDefName, theScope, new GenericBeanAspectFactory(this.aspectDefName, this.advice), false) : new ManagedAspectDefinition(this.aspectDefName, theScope, (AspectFactory)new GenericAspectFactory(this.adviceName, null)));
            this.manager.addAspectDefinition((AspectDefinition)this.definition);
        }
        if (this.adviceBean != null && this.advice != null) {
            this.definition.setDeployed(true);
            GenericBeanAspectFactory factory = (GenericBeanAspectFactory)this.definition.getFactory();
            factory.setBeanFactory(this.advice);
        }
        log.debug((Object)("Bound aspect " + this.aspectDefName + "; deployed:" + this.definition.isDeployed()));
    }

    public void uninstall() throws Exception {
        this.stop();
    }

    public void stop() {
        this.aspectDefName = this.adviceBean != null ? this.adviceBean : this.myname;
        log.debug((Object)("Unbinding aspect " + this.aspectDefName));
        this.manager.removeAspectDefinition(this.aspectDefName);
        if (this.definition != null) {
            this.definition.undeploy();
            this.definition = null;
        }
    }
}

