/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.util.id.GUID;

public class StackBinding {
    protected String name = GUID.asString();
    protected AspectManager manager;
    protected String pointcut;
    protected List advices;

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public String getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(String pointcut) {
        this.pointcut = pointcut;
    }

    public List getAdvices() {
        return this.advices;
    }

    public void setAdvices(List advices) {
        this.advices = advices;
    }

    public void start() throws Exception {
        if (this.pointcut == null) {
            throw new IllegalArgumentException("Null pointcut");
        }
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.advices == null || this.advices.size() == 0) {
            throw new IllegalArgumentException("No advices");
        }
        AdviceBinding binding = new AdviceBinding(this.name, this.pointcut, null);
        for (AspectDefinition aspect : this.advices) {
            binding.addInterceptorFactory((InterceptorFactory)new ScopedInterceptorFactory(aspect));
        }
        this.manager.addBinding(binding);
    }

    public void stop() throws Exception {
        this.manager.removeBinding(this.name);
    }
}

