/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import java.lang.reflect.Constructor;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.joinpoint.plugins.BasicConstructorJoinPoint;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.repository.spi.MetaDataContext;

public class AOPConstructorJoinpoint
extends BasicConstructorJoinPoint {
    AOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
    MetaDataContext metaDataContext;

    public AOPConstructorJoinpoint(org.jboss.reflect.spi.ConstructorInfo constructorInfo, MetaDataContext metaDataContext) {
        super(constructorInfo);
        this.metaDataContext = metaDataContext;
    }

    public Object dispatch() throws Throwable {
        Class clazz = this.constructorInfo.getDeclaringClass().getType();
        AspectManager manager = AspectManager.instance();
        if (manager.isNonAdvisableClassName(clazz.getName())) {
            return super.dispatch();
        }
        ContainerCache cache = ContainerCache.initialise((AspectManager)manager, (Class)clazz, (Object)this.metaDataContext);
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        Object target = this.createTarget(cache, params);
        params.setProxiedClass(target.getClass());
        params.setMetaDataContext((Object)this.metaDataContext);
        params.setTarget(target);
        params.setContainerCache(cache);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    private Object createTarget(ContainerCache cache, AOPProxyFactoryParameters params) throws Throwable {
        Advisor advisor = cache.getAdvisor();
        if (advisor != null) {
            Interceptor[] interceptors;
            ConstructorInfo aopinfo = this.findAopConstructorInfo(advisor);
            Interceptor[] interceptorArray = interceptors = aopinfo != null ? aopinfo.getInterceptors() : null;
            if (interceptors != null) {
                ConstructorInvocation inv = new ConstructorInvocation(aopinfo, aopinfo.getInterceptors());
                inv.setArguments(this.getArguments());
                return inv.invokeNext();
            }
            if (this.getConstructorInfo().getParameterTypes().length > 0) {
                Constructor<?> constructor = null;
                if (aopinfo == null) {
                    Constructor<?>[] ctors;
                    Class clazz = advisor.getClazz();
                    for (Constructor<?> ctor : ctors = clazz.getConstructors()) {
                        if (!this.matchConstructor(ctor)) continue;
                        constructor = ctor;
                        break;
                    }
                } else {
                    constructor = aopinfo.getConstructor();
                }
                params.setCtor((Class[])constructor.getParameterTypes(), this.getArguments());
            }
        }
        return super.dispatch();
    }

    private ConstructorInfo findAopConstructorInfo(Advisor advisor) {
        ConstructorInfo[] infos = advisor.getConstructorInfos();
        for (int i = 0; i < infos.length; ++i) {
            if (!this.matchConstructor(infos[i].getConstructor())) continue;
            return infos[i];
        }
        return null;
    }

    private boolean matchConstructor(Constructor ctor) {
        Class<?>[] ctorParams;
        TypeInfo[] params = this.constructorInfo.getParameterTypes();
        if (params.length == (ctorParams = ctor.getParameterTypes()).length) {
            boolean match = true;
            for (int p = 0; p < params.length; ++p) {
                if (params[p].getName().equals(ctorParams[p].getName())) continue;
                match = false;
                break;
            }
            if (match) {
                return true;
            }
        }
        return false;
    }
}

