/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ReflectiveAspectBinder;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.microcontainer.beans.ManagedAspectDefinition;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.util.Advisable;
import org.jboss.aop.util.ClassInfoMethodHashing;
import org.jboss.classadapter.plugins.dependency.AbstractDependencyBuilder;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.classadapter.spi.Dependency;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationValueFactory;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactoryImpl;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ArrayValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.StringValue;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.reflect.spi.Value;
import org.jboss.repository.spi.MetaDataContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPDependencyBuilderDelegate
extends AbstractDependencyBuilder {
    private static final String DEPENDENCY_CLASS_NAME = Dependency.class.getName();
    private static final String DEPENDENCY_NAME_ATTRIBUTE = "name";
    private static final IntrospectionTypeInfoFactoryImpl typeInfoFactory = new IntrospectionTypeInfoFactoryImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDependencies(ClassAdapter classAdapter) {
        AspectManager manager = AspectManager.instance();
        try {
            ClassInfo classInfo = classAdapter.getClassInfo();
            String className = classInfo.getName();
            if (className != null) {
                Advisor advisor;
                if (manager.isNonAdvisableClassName(className)) {
                    return super.getDependencies(classAdapter);
                }
                MetaDataContext metaDataContext = classAdapter.getMetaDataContext();
                ClassLoader loader = classAdapter.getClassLoader();
                if (loader == null) {
                    loader = Thread.currentThread().getContextClassLoader();
                }
                Class<?> clazz = loader.loadClass(className);
                Object object = ContainerCache.mapLock;
                synchronized (object) {
                    ContainerCache cache = ContainerCache.initialise((AspectManager)manager, clazz, (Object)metaDataContext);
                    advisor = cache.getAdvisor();
                }
                ReflectiveAspectBinder binder = new ReflectiveAspectBinder(clazz, advisor);
                HashSet aspects = binder.getAspects();
                ArrayList<Object> depends = new ArrayList<Object>();
                if (aspects != null && aspects.size() > 0) {
                    for (AspectDefinition def : aspects) {
                        if (!(def instanceof ManagedAspectDefinition)) continue;
                        depends.add(def.getName());
                    }
                }
                HashSet<Object> annotationDependencies = this.getAnnotationDependencies(classInfo, metaDataContext);
                depends.addAll(annotationDependencies);
                return depends;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private HashSet<Object> getAnnotationDependencies(ClassInfo classInfo, MetaDataContext metaDataContext) {
        try {
            HashSet<Object> dependencies = new HashSet<Object>();
            this.getClassAnnotationDependencies(classInfo, metaDataContext, dependencies);
            this.getMethodAnnotationDependencies(classInfo, metaDataContext, dependencies);
            return dependencies;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void getClassAnnotationDependencies(ClassInfo classInfo, MetaDataContext metaDataContext, HashSet<Object> dependencies) throws Exception {
        HashMap<String, ArrayList<String>> realMap = new HashMap<String, ArrayList<String>>();
        this.getRealClassAnnotationDependencies(classInfo, realMap);
        HashMap<String, ArrayList<String>> metaMap = new HashMap<String, ArrayList<String>>();
        this.getMetaDataContextClassAnnotationDependencies(metaDataContext, metaMap);
        this.addAllDependenciesToSet(dependencies, realMap, metaMap);
    }

    private void getRealClassAnnotationDependencies(ClassInfo classInfo, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        AnnotationValue[] annotations = classInfo.getAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            this.getDependenciesForAnnotation(annotations[i].getType().getName(), annotations[i], dependencies);
        }
    }

    private void getMetaDataContextClassAnnotationDependencies(MetaDataContext metaDataContext, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        if (metaDataContext != null) {
            for (Object annotation : metaDataContext.getAnnotations()) {
                this.getDependenciesForMetaDataAnnotation(annotation, dependencies);
            }
        }
    }

    private void getMethodAnnotationDependencies(ClassInfo classInfo, MetaDataContext metaDataContext, HashSet<Object> dependencies) throws Exception {
        HashMap methodMap = ClassInfoMethodHashing.getMethodMap((ClassInfo)classInfo);
        if (methodMap != null) {
            for (MethodInfo method : methodMap.values()) {
                if (!Advisable.isAdvisableMethod((int)method.getModifiers(), (String)method.getName())) continue;
                HashMap<String, ArrayList<String>> classMap = new HashMap<String, ArrayList<String>>();
                this.getRealMethodAnnotationDependencies(method, classMap);
                HashMap<String, ArrayList<String>> overrideMap = new HashMap<String, ArrayList<String>>();
                this.getMetaDataContextMethodAnnotationDependencies(method, metaDataContext, overrideMap);
                this.addAllDependenciesToSet(dependencies, classMap, overrideMap);
            }
        }
    }

    private void getRealMethodAnnotationDependencies(MethodInfo methodInfo, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        AnnotationValue[] annotations = methodInfo.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                this.getDependenciesForAnnotation(annotations[i].getType().getName(), annotations[i], dependencies);
            }
        }
    }

    private void getMetaDataContextMethodAnnotationDependencies(MethodInfo method, MetaDataContext metaDataContext, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        if (metaDataContext != null) {
            long hash = ClassInfoMethodHashing.methodHash((MethodInfo)method);
            List methodAnnotations = metaDataContext.getAnnotationsForMethod(hash);
            for (Object annotation : methodAnnotations) {
                this.getDependenciesForMetaDataAnnotation(annotation, dependencies);
            }
        }
    }

    private void getDependenciesForMetaDataAnnotation(Object annotation, HashMap<String, ArrayList<String>> dependencies) throws Exception {
        AnnotationInfo info;
        Class<?> clazz = annotation.getClass().getInterfaces()[0];
        try {
            info = (AnnotationInfo)typeInfoFactory.getTypeInfo(clazz);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error creating annotation for " + clazz.getName(), e);
        }
        AnnotationValue value = AnnotationValueFactory.createAnnotationValue((TypeInfoFactory)typeInfoFactory, (AnnotationHelper)typeInfoFactory, (AnnotationInfo)info, (Object)annotation);
        this.getDependenciesForAnnotation(info.getName(), value, dependencies);
    }

    private void getDependenciesForAnnotation(String topLevelAnnotationName, AnnotationValue annotation, HashMap<String, ArrayList<String>> dependencies) {
        if (annotation != null) {
            this.addAnnotationAttributeDependencies(topLevelAnnotationName, annotation, dependencies);
            AnnotationValue[] annotationAnnotations = annotation.getAnnotationType().getAnnotations();
            for (int i = 0; i < annotationAnnotations.length; ++i) {
                if (!annotationAnnotations[i].getAnnotationType().getName().equals(DEPENDENCY_CLASS_NAME)) continue;
                StringValue value = (StringValue)annotationAnnotations[i].getValue(DEPENDENCY_NAME_ATTRIBUTE);
                StringValue dependency = (StringValue)annotation.getValue(value.getValue());
                this.addDependency(topLevelAnnotationName, dependency, dependencies);
            }
        }
    }

    private void addAnnotationAttributeDependencies(String topLevelAnnotationName, AnnotationValue annotation, HashMap<String, ArrayList<String>> dependencies) {
        MethodInfo[] attributes = annotation.getAnnotationType().getDeclaredMethods();
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                ArrayValue arrVal;
                TypeInfo type;
                Value value = annotation.getValue(attributes[i].getName());
                if (value instanceof AnnotationValue) {
                    this.getDependenciesForAnnotation(topLevelAnnotationName, (AnnotationValue)value, dependencies);
                    continue;
                }
                if (!(value instanceof ArrayValue) || !((type = ((ArrayInfo)(arrVal = (ArrayValue)value).getType()).getComponentType()) instanceof AnnotationInfo)) continue;
                Value[] values = arrVal.getValues();
                for (int j = 0; j < values.length; ++j) {
                    this.getDependenciesForAnnotation(topLevelAnnotationName, (AnnotationValue)values[j], dependencies);
                }
            }
        }
    }

    private void addDependency(String topLevelAnnotationName, StringValue dependency, HashMap<String, ArrayList<String>> dependencies) {
        ArrayList<String> list = dependencies.get(topLevelAnnotationName);
        if (list == null) {
            list = new ArrayList();
            dependencies.put(topLevelAnnotationName, list);
        }
        list.add(dependency.getValue());
    }

    private void addAllDependenciesToSet(HashSet<Object> dependencies, HashMap<String, ArrayList<String>> classMap, HashMap<String, ArrayList<String>> overrideMap) {
        HashMap<String, ArrayList<String>> dependencyMap = this.mergeClassAndOverrideMaps(classMap, overrideMap);
        if (dependencyMap.size() > 0) {
            for (ArrayList<String> deps : dependencyMap.values()) {
                dependencies.addAll(deps);
            }
        }
    }

    private HashMap<String, ArrayList<String>> mergeClassAndOverrideMaps(HashMap<String, ArrayList<String>> classMap, HashMap<String, ArrayList<String>> overrideMap) {
        if (classMap.size() == 0 && overrideMap.size() == 0) {
            return classMap;
        }
        if (classMap.size() > 0 && overrideMap.size() == 0) {
            return classMap;
        }
        if (classMap.size() == 0 && overrideMap.size() > 0) {
            return overrideMap;
        }
        for (String key : overrideMap.keySet()) {
            classMap.put(key, overrideMap.get(key));
        }
        return classMap;
    }
}

