/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import org.jboss.aop.microcontainer.integration.AOPDeployedChecker;
import org.jboss.joinpoint.plugins.BasicConstructorJoinPoint;
import org.jboss.joinpoint.plugins.BasicJoinpointFactory;
import org.jboss.joinpoint.spi.ConstructorJoinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.repository.spi.MetaDataContext;

public class AOPJoinpointFactory
extends BasicJoinpointFactory {
    static volatile ConstructorInfo ctorInfo;

    public AOPJoinpointFactory(ClassInfo classInfo, MetaDataContext metaDataContext) {
        super(classInfo, metaDataContext);
    }

    public ConstructorJoinpoint getConstructorJoinpoint(ConstructorInfo constructorInfo) throws JoinpointException {
        ConstructorInfo info = this.getAOPJoinpointConstructorInfo(constructorInfo);
        if (info != null) {
            return this.createAOPConstructorJoinpoint(info, constructorInfo);
        }
        return super.getConstructorJoinpoint(constructorInfo);
    }

    private synchronized ConstructorInfo getAOPJoinpointConstructorInfo(ConstructorInfo currentConstructorInfo) throws JoinpointException {
        if (ctorInfo != null) {
            return ctorInfo;
        }
        Class clazz = AOPDeployedChecker.getClassIfExists(this.classInfo.getType().getClassLoader(), "org.jboss.aop.microcontainer.integration.AOPConstructorJoinpoint");
        if (clazz == null) {
            return null;
        }
        IntrospectionTypeInfoFactory factory = new IntrospectionTypeInfoFactory();
        ClassInfo info = (ClassInfo)factory.getTypeInfo(clazz);
        ConstructorInfo[] ctors = info.getDeclaredConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            if (ctors[i].getParameterTypes().length != 2 || !ctors[i].getParameterTypes()[0].getName().equals(ConstructorInfo.class.getName()) || !ctors[i].getParameterTypes()[1].getName().equals(MetaDataContext.class.getName())) continue;
            ctorInfo = ctors[i];
            break;
        }
        if (ctorInfo == null) {
            throw new JoinpointException("No constructor found with the reqiured signature AOPConstructorJoinpoint(ConstructorInfo, MetadataContext)");
        }
        return ctorInfo;
    }

    private ConstructorJoinpoint createAOPConstructorJoinpoint(ConstructorInfo info, ConstructorInfo aopCtorInfo) throws JoinpointException {
        BasicConstructorJoinPoint jp = new BasicConstructorJoinPoint(info);
        jp.setArguments(new Object[]{aopCtorInfo, this.metaDataContext});
        try {
            return (ConstructorJoinpoint)jp.dispatch();
        }
        catch (Throwable e) {
            throw new JoinpointException("Error calling AOPConstructorJoinpoint constructor", e);
        }
    }
}

