/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.util.ClassInfoMethodHashing;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.kernel.spi.metadata.MutableMetaDataContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.repository.MetaDataRepository;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.AnnotationItem;
import org.jboss.metadata.spi.retrieval.AnnotationsItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.repository.spi.MetaDataContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOPMetaDataContext
implements MutableMetaDataContext {
    static final List<Annotation> EMPTY_ANNOTATIONS = new ArrayList<Annotation>();
    Scope scope;
    Object target;
    MutableMetaDataRepository repository;
    String beanName;
    ScopeKey instanceKey;

    public AOPMetaDataContext(MutableMetaDataRepository repository, String beanName) {
        this.repository = repository;
        this.beanName = beanName;
        this.scope = new Scope(CommonLevels.INSTANCE, beanName);
        this.instanceKey = new ScopeKey(this.scope);
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> ann) {
        return this.getAnnotation(ann) != null;
    }

    public <T extends Annotation> Annotation getAnnotation(Class<T> ann) {
        return this.getAnnotation(this.instanceKey, ann);
    }

    public <T extends Annotation> boolean hasAnnotationForMethod(long methodHash, Class<T> ann) {
        return this.getAnnotationForMethod(methodHash, ann) != null;
    }

    public <T extends Annotation> Annotation getAnnotationForMethod(long methodHash, Class<T> ann) {
        ScopeKey joinpointKey = this.createHashedJoinpointKey(methodHash);
        return this.getAnnotation(joinpointKey, ann);
    }

    public List<Annotation> getAnnotations() {
        return this.getAnnotations(this.instanceKey);
    }

    public List<Annotation> getAnnotationsForMethod(long methodHash) {
        ScopeKey joinpointKey = this.createHashedJoinpointKey(methodHash);
        return this.getAnnotations(joinpointKey);
    }

    public List<Annotation> getAnnotationsForMethods(long[] methodHashes) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (long hash : methodHashes) {
            ScopeKey joinpointKey = this.createHashedJoinpointKey(hash);
            List<Annotation> methodAnnotations = this.getAnnotations(joinpointKey);
            annotations.addAll(methodAnnotations);
        }
        return annotations;
    }

    public MetaDataRepository getRepository() {
        return this.repository;
    }

    public void addAnnotations(Set<AnnotationMetaData> annotations) {
        if (annotations.size() == 0) {
            return;
        }
        MemoryMetaDataLoader retrieval = new MemoryMetaDataLoader(this.instanceKey);
        for (AnnotationMetaData annotationMetaData : annotations) {
            Annotation annotation = annotationMetaData.getAnnotationInstance();
            retrieval.addAnnotation(annotation);
        }
        this.repository.addMetaDataRetrieval((MetaDataRetrieval)retrieval);
    }

    public void addPropertyAnnotations(String propertyName, Set<PropertyInfo> propertyInfos, Set<AnnotationMetaData> annotations) {
        for (PropertyInfo info : propertyInfos) {
            if (!propertyName.equals(info.getName())) continue;
            MemoryMetaDataLoader getterRetrieval = this.createGetterMetaDataRetrieval(info);
            MemoryMetaDataLoader setterRetrieval = this.createSetterMetaDataRetrieval(info);
            if (getterRetrieval == null && setterRetrieval == null) continue;
            for (AnnotationMetaData annotation : annotations) {
                if (getterRetrieval != null) {
                    getterRetrieval.addAnnotation(annotation.getAnnotationInstance());
                }
                if (setterRetrieval == null) continue;
                setterRetrieval.addAnnotation(annotation.getAnnotationInstance());
            }
            if (getterRetrieval != null) {
                this.repository.addMetaDataRetrieval((MetaDataRetrieval)getterRetrieval);
            }
            if (setterRetrieval == null) continue;
            this.repository.addMetaDataRetrieval((MetaDataRetrieval)setterRetrieval);
        }
    }

    public void setTarget(Object tgt) {
        if (tgt == null) {
            return;
        }
        this.target = tgt;
        Advisor advisor = null;
        if (tgt instanceof AspectManaged) {
            advisor = (Advisor)((AspectManaged)tgt).getInstanceAdvisor();
        } else if (tgt instanceof Advised) {
            advisor = (Advisor)((Advised)tgt)._getInstanceAdvisor();
        }
        if (advisor != null) {
            MetaDataContext advCtx = advisor.getMetadataContext();
            if (advCtx != null && advCtx != this) {
                throw new RuntimeException("Different context being set in constructed advisor");
            }
            if (advCtx == null) {
                advisor.setMetadataContext((Object)this);
            }
        }
    }

    private MemoryMetaDataLoader createGetterMetaDataRetrieval(PropertyInfo propertyInfo) {
        MethodInfo getter = propertyInfo.getGetter();
        return this.createMethodMetaDataRetrieval(getter);
    }

    private MemoryMetaDataLoader createSetterMetaDataRetrieval(PropertyInfo propertyInfo) {
        MethodInfo setter = propertyInfo.getSetter();
        return this.createMethodMetaDataRetrieval(setter);
    }

    private MemoryMetaDataLoader createMethodMetaDataRetrieval(MethodInfo accessor) {
        if (accessor == null) {
            return null;
        }
        long hash = ClassInfoMethodHashing.methodHash((MethodInfo)accessor);
        ScopeKey joinpointKey = this.createHashedJoinpointKey(hash);
        MemoryMetaDataLoader retrieval = new MemoryMetaDataLoader(joinpointKey);
        return retrieval;
    }

    private ScopeKey createHashedJoinpointKey(long hash) {
        ScopeKey joinpointKey = new ScopeKey(this.instanceKey.getScopes());
        joinpointKey.addScope(CommonLevels.JOINPOINT, String.valueOf(hash));
        return joinpointKey;
    }

    private <T extends Annotation> Annotation getAnnotation(ScopeKey key, Class<T> ann) {
        AnnotationItem item;
        MetaDataRetrieval retrieval = this.repository.getMetaDataRetrieval(key);
        if (retrieval != null && (item = retrieval.retrieveAnnotation(ann)) != null) {
            return item.getAnnotation();
        }
        return null;
    }

    private List<Annotation> getAnnotations(ScopeKey key) {
        AnnotationsItem item;
        MetaDataRetrieval retrieval = this.repository.getMetaDataRetrieval(key);
        if (retrieval != null && (item = retrieval.retrieveAnnotations()) != null) {
            AnnotationItem[] items = item.getAnnotations();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (AnnotationItem aitem : items) {
                annotations.add(aitem.getAnnotation());
            }
            return annotations;
        }
        return EMPTY_ANNOTATIONS;
    }
}

