/*
 * Decompiled with CFR 0.152.
 */
package org.josso.tc55.agent;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.josso.Lookup;
import org.josso.agent.LocalSession;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SingleSignOnEntry;
import org.josso.tc55.agent.CatalinaLocalSession;
import org.josso.tc55.agent.CatalinaSSOAgent;
import org.josso.tc55.agent.CatalinaSSOAgentRequest;

public class SSOAgentValve
extends ValveBase
implements Lifecycle,
SessionListener {
    private static final String JOSSO_SINGLE_SIGN_ON_COOKIE = "JOSSO_SESSIONID";
    protected int debug = 0;
    protected static String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected boolean started = false;
    private CatalinaSSOAgent _agent;
    HashMap _sessionMap = new HashMap();

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void sessionEvent(SessionEvent event) {
        LocalSession localSession = (LocalSession)this._sessionMap.get(event.getSession());
        if (event.getType().equals("destroySession")) {
            localSession.expire();
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("Agent already started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this._agent = (CatalinaSSOAgent)Lookup.getInstance().lookupSSOAgent();
            this._agent.setDebug(this.debug);
            this._agent.setCatalinaContainer(this.container);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new LifecycleException("Error starting SSO Agent : " + e.getMessage());
        }
        this._agent.start();
        if (this.debug >= 1) {
            this.log("Started");
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("Agent not started");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this._agent.stop();
        if (this.debug >= 1) {
            this.log("Stopped");
        }
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        HttpServletRequest hreq = request.getRequest();
        HttpServletResponse hres = response.getResponse();
        if (this.debug >= 1) {
            this.log("Processing : " + hreq.getContextPath());
        }
        try {
            Realm realm;
            SecurityConstraint[] constraints;
            String contextPath = hreq.getContextPath();
            if ("".equals(contextPath)) {
                contextPath = "/";
            }
            if (!this._agent.isPartnerApp(contextPath)) {
                this.getNext().invoke(request, response);
                if (this.debug >= 1) {
                    this.log("Context is not a josso partner app : " + hreq.getContextPath());
                }
                return;
            }
            if (this.debug >= 1) {
                this.log("Checking if its a josso_login_request for '" + hreq.getRequestURI() + "'");
            }
            if (hreq.getRequestURI().endsWith("/josso_login/")) {
                if (this.debug >= 1) {
                    this.log("josso_login_request received for uri '" + hreq.getRequestURI() + "'");
                }
                String loginUrl = this._agent.getGatewayLoginUrl();
                String onErrorUrl = this._agent.getGatewayLoginErrorUrl();
                String backto = this.buildBackToURL(hreq, "/josso_security_check");
                loginUrl = loginUrl + "?josso_back_to=" + backto + (onErrorUrl != null ? "&josso_on_error=" + onErrorUrl : "");
                if (this.debug >= 1) {
                    this.log("Redirecting to login url '" + loginUrl + "'");
                }
                hres.sendRedirect(hres.encodeRedirectURL(loginUrl));
                return;
            }
            if (this.debug >= 1) {
                this.log("Checking if its a josso_logout request for '" + hreq.getRequestURI() + "'");
            }
            if (hreq.getRequestURI().endsWith("/josso_logout/")) {
                if (this.debug >= 1) {
                    this.log("josso_logout request received for uri '" + hreq.getRequestURI() + "'");
                }
                String backto = this.buildBackToURL(hreq, "/");
                String logoutUrl = this._agent.getGatewayLogoutUrl() + (backto != null ? "?josso_back_to=" + backto : "");
                if (this.debug >= 1) {
                    this.log("Redirecting to logout url '" + logoutUrl + "'");
                }
                hres.sendRedirect(hres.encodeRedirectURL(logoutUrl));
                return;
            }
            if (this.debug >= 1) {
                this.log("Checking for SSO cookie");
            }
            Cookie cookie = null;
            Cookie[] cookies = hreq.getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            for (int i = 0; i < cookies.length; ++i) {
                if (!JOSSO_SINGLE_SIGN_ON_COOKIE.equals(cookies[i].getName())) continue;
                cookie = cookies[i];
                break;
            }
            if (cookie == null) {
                if (this.debug >= 1) {
                    this.log("SSO cookie is not present, checking for outbound relaying");
                }
                if (!hreq.getRequestURI().endsWith("/josso_security_check") || hreq.getParameter("josso_assertion_id") == null) {
                    this.log("SSO cookie not present and relaying was not requested, skipping");
                    this.getNext().invoke(request, response);
                    return;
                }
            }
            String[] ignoredWebResources = this._agent.getPartnerAppConfig(contextPath).getIgnoredWebRources();
            if (this.debug >= 1) {
                this.log("Found [" + (ignoredWebResources != null ? ignoredWebResources.length + "" : "no") + "] ignored web resources ");
            }
            if (ignoredWebResources != null && ignoredWebResources.length > 0 && (constraints = (realm = request.getContext().getRealm()).findSecurityConstraints(request, request.getContext())) != null) {
                for (int i = 0; i < ignoredWebResources.length; ++i) {
                    String ignoredWebResource = ignoredWebResources[i];
                    for (int j = 0; j < constraints.length; ++j) {
                        SecurityConstraint constraint = constraints[j];
                        if (constraint.findCollection(ignoredWebResource) == null) continue;
                        if (this.debug >= 1) {
                            this.log("Not subject to SSO protection :  web-resource-name:" + ignoredWebResource);
                        }
                        this.getNext().invoke(request, response);
                        return;
                    }
                }
            }
            String jossoSessionId = cookie == null ? null : cookie.getValue();
            Session session = this.getSession(request, true);
            if (this.debug >= 1) {
                this.log("Session is: " + session);
            }
            CatalinaLocalSession localSession = new CatalinaLocalSession(session);
            if (this.debug >= 1) {
                this.log("Executing agent...");
            }
            this._agent.setCatalinaContainer((Container)request.getContext());
            if (this.debug >= 1) {
                this.log("Checking if its a josso_security_check for '" + hreq.getRequestURI() + "'");
            }
            if (hreq.getRequestURI().endsWith("/josso_security_check") && hreq.getParameter("josso_assertion_id") != null) {
                if (this.debug >= 1) {
                    this.log("josso_security_check received for uri '" + hreq.getRequestURI() + "' assertion id '" + hreq.getParameter("josso_assertion_id"));
                }
                String assertionId = hreq.getParameter("josso_assertion_id");
                if (this.debug >= 1) {
                    this.log("Outbound relaying requested for assertion id [" + assertionId + "]");
                }
                CatalinaSSOAgentRequest relayRequest = new CatalinaSSOAgentRequest(2, null, localSession, assertionId);
                relayRequest.setContext(request.getContext());
                SingleSignOnEntry entry = this._agent.processRequest((SSOAgentRequest)relayRequest);
                if (this.debug >= 1) {
                    this.log("Outbound relaying succesfull for assertion id [" + assertionId + "]");
                }
                if (this.debug >= 1) {
                    this.log("Assertion id [" + assertionId + "] mapped to SSO session id [" + entry.ssoId + "]");
                }
                cookie = this.newJossoCookie(request.getContextPath(), entry.ssoId);
                hres.addCookie(cookie);
                String requestURI = this.savedRequestURL(session);
                if (requestURI == null) {
                    requestURI = hreq.getRequestURI().substring(0, hreq.getRequestURI().length() - "/josso_security_check".length());
                    String singlePointOfAccess = this._agent.getSinglePointOfAccess();
                    if (singlePointOfAccess != null) {
                        requestURI = singlePointOfAccess + requestURI;
                    } else {
                        String reverseProxyHost = hreq.getHeader("Josso-ReversE-Proxy");
                        if (reverseProxyHost != null) {
                            requestURI = reverseProxyHost + requestURI;
                        }
                    }
                    if (this.debug >= 1) {
                        this.log("No saved request found, using : '" + requestURI + "'");
                    }
                }
                if (this.debug >= 1) {
                    this.log("Redirecting to original '" + requestURI + "'");
                }
                hres.sendRedirect(hres.encodeRedirectURL(requestURI));
                return;
            }
            this.log("Creating Security Context for Session [" + session + "]");
            CatalinaSSOAgentRequest r = new CatalinaSSOAgentRequest(1, jossoSessionId, localSession);
            r.setContext(request.getContext());
            SingleSignOnEntry entry = this._agent.processRequest((SSOAgentRequest)r);
            if (this.debug >= 1) {
                this.log("Executed agent.");
            }
            if (this._sessionMap.get(localSession.getWrapped()) == null) {
                session.addSessionListener((SessionListener)this);
                this._sessionMap.put(session, localSession);
            }
            if (this.debug >= 1) {
                this.log("Process request for '" + hreq.getRequestURI() + "'");
            }
            if (entry != null) {
                if (this.debug >= 1) {
                    this.log("Principal '" + entry.principal + "' has already been authenticated");
                }
                request.setAuthType(entry.authType);
                request.setUserPrincipal(entry.principal);
            }
            hreq.setAttribute("org.josso.agent.gateway-login-url", (Object)this._agent.getGatewayLoginUrl());
            hreq.setAttribute("org.josso.agent.gateway-logout-url", (Object)this._agent.getGatewayLogoutUrl());
            this.getNext().invoke(request, response);
        }
        finally {
            if (this.debug >= 1) {
                this.log("Processed : " + hreq.getContextPath());
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SingleSignOn[");
        sb.append(this.container != null ? this.container.getName() : "");
        sb.append("]");
        return sb.toString();
    }

    protected Session getSession(Request request) {
        return this.getSession(request, false);
    }

    protected Session getSession(Request request, boolean create) {
        HttpServletRequest hreq = request.getRequest();
        HttpSession hses = hreq.getSession(create);
        if (this.debug >= 1) {
            this.log("getCurrentSession() : hses " + hses);
        }
        if (hses == null) {
            return null;
        }
        Manager manager = request.getContext().getManager();
        if (this.debug >= 1) {
            this.log("getCurrentSession() : manager is " + manager);
        }
        if (manager == null) {
            return null;
        }
        try {
            return manager.findSession(hses.getId());
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String buildBackToURL(HttpServletRequest hreq, String uri) {
        String backto = null;
        String contextPath = hreq.getContextPath();
        String reverseProxyHost = hreq.getHeader("Josso-ReversE-Proxy");
        String singlePointOfAccess = this._agent.getSinglePointOfAccess();
        if (singlePointOfAccess != null) {
            if (this.debug >= 1) {
                this.log("josso_back_to option : singlePointOfAccess: " + singlePointOfAccess);
            }
            backto = singlePointOfAccess + contextPath + uri;
        } else if (reverseProxyHost != null) {
            if (this.debug >= 1) {
                this.log("josso_back_to option : reverse-proxy-host: " + reverseProxyHost);
            }
            backto = reverseProxyHost + contextPath + uri;
        } else {
            StringBuffer mySelf = HttpUtils.getRequestURL((HttpServletRequest)hreq);
            backto = mySelf.substring(0, mySelf.indexOf(contextPath));
            if (this.debug >= 1) {
                this.log("josso_back_to option : default: " + backto);
            }
            backto = backto + contextPath + uri;
        }
        if (this.debug >= 1) {
            this.log("Using josso_back_to : " + backto);
        }
        return backto;
    }

    protected void log(String message) {
        if (this.container != null) {
            if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().debug((Object)(this.toString() + ": " + message));
            }
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.container != null) {
            if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().debug((Object)(this.toString() + ": " + message), throwable);
            }
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    private String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            sb.append('?');
            sb.append(saved.getQueryString());
        }
        return sb.toString();
    }

    protected Cookie newJossoCookie(String path, String value) {
        Cookie ssoCookie = new Cookie(JOSSO_SINGLE_SIGN_ON_COOKIE, value);
        ssoCookie.setMaxAge(-1);
        ssoCookie.setPath(path);
        return ssoCookie;
    }
}

