/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.snowdrop.licenses.sanitiser.LicenseSanitiser;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseSummary;
import org.apache.maven.artifact.Artifact;

public class LicenseSummaryFactory {
    private final LicenseSanitiser licenseSanitiser;

    public LicenseSummaryFactory(LicenseSanitiser licenseSanitiser) {
        this.licenseSanitiser = licenseSanitiser;
    }

    public LicenseSummary getLicenseSummary(Collection<Artifact> artifacts) {
        List<DependencyElement> dependencyElements = artifacts.parallelStream().map(DependencyElement::new).map(this.licenseSanitiser::fix).sorted(Comparator.comparing(DependencyElement::getGroupId).thenComparing(DependencyElement::getArtifactId).thenComparing(DependencyElement::getVersion)).collect(Collectors.toList());
        return new LicenseSummary(dependencyElements);
    }
}

