/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses;

import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import me.snowdrop.licenses.LicensesGenerator;
import me.snowdrop.licenses.LicensesGeneratorException;
import me.snowdrop.licenses.properties.GeneratorProperties;

public class LicensesGeneratorApplication {
    public static void main(String ... args) throws Exception {
        Properties properties = LicensesGeneratorApplication.argsToProperties(args);
        LicensesGenerator licensesGenerator = LicensesGeneratorApplication.getLicensesGenerator(properties);
        String pomPath = properties.getProperty("pom");
        String resultPath = properties.getProperty("destination");
        licensesGenerator.generateLicensesForPom(pomPath, resultPath);
    }

    private static LicensesGenerator getLicensesGenerator(Properties properties) throws LicensesGeneratorException {
        if (properties.getProperty("generatorProperties") != null) {
            GeneratorProperties generatorProperties = new GeneratorProperties(properties.getProperty("generatorProperties"));
            return new LicensesGenerator(generatorProperties);
        }
        return new LicensesGenerator();
    }

    private static Properties argsToProperties(String ... args) {
        Properties properties = new Properties();
        Arrays.stream(args).map(s -> s.replace("-D", "")).filter(s -> s.contains("=")).map(s -> s.split("=")).filter(a -> ((String[])a).length == 2).forEach(a -> properties.put(a[0], a[1]));
        Objects.requireNonNull(properties.getProperty("pom"), "'pom' is required");
        Objects.requireNonNull(properties.getProperty("destination"), "'destination' is required");
        return properties;
    }
}

