/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser;

import java.util.Optional;
import java.util.Set;
import me.snowdrop.licenses.sanitiser.LicenseSanitiser;
import me.snowdrop.licenses.sanitiser.RedHatLicense;
import me.snowdrop.licenses.utils.JsonUtils;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;

public class AliasLicenseSanitiser
implements LicenseSanitiser {
    private final Set<RedHatLicense> redHatLicenses;
    private final LicenseSanitiser next;

    public AliasLicenseSanitiser(String namesFilePath, LicenseSanitiser next) {
        this.redHatLicenses = JsonUtils.loadJsonToSet(namesFilePath, RedHatLicense::new);
        this.next = next;
    }

    @Override
    public DependencyElement fix(DependencyElement originalDependencyElement) {
        boolean shouldCallNext = false;
        DependencyElement dependencyElement = new DependencyElement(originalDependencyElement);
        for (LicenseElement licenseElement : dependencyElement.getLicenses()) {
            Optional<RedHatLicense> redHatLicenseOptional = this.redHatLicenses.stream().filter(redHatLicense -> redHatLicense.isAliasTo(licenseElement)).findFirst();
            if (redHatLicenseOptional.isPresent()) {
                RedHatLicense redHatLicense2 = redHatLicenseOptional.get();
                licenseElement.setName(redHatLicense2.getName());
                licenseElement.setUrl(redHatLicense2.getUrl());
                licenseElement.setTextUrl(redHatLicense2.getTextUrl());
                continue;
            }
            shouldCallNext = true;
        }
        if (shouldCallNext) {
            return this.next.fix(dependencyElement);
        }
        return dependencyElement;
    }
}

